<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#8B5CF6',
                        accent: '#06B6D4',
                        'dark-100': '#0F172A',
                        'dark-200': '#1E293B',
                        'dark-300': '#334155',
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'system-ui', 'sans-serif'],
                    },
                },
            },
        }
    </script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.min.js"></script>
    
    <style>
        body {
            background: linear-gradient(135deg, #0F172A 0%, #1E293B 50%, #0F172A 100%);
            background-attachment: fixed;
        }
        
        .input-glow:focus {
            box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.2), 0 0 20px rgba(139, 92, 246, 0.1);
        }
        
        .btn-shine {
            background-size: 200% auto;
            animation: shine 3s linear infinite;
        }
        
        @keyframes shine {
            to {
                background-position: 200% center;
            }
        }
        
        .card-glow {
            box-shadow: 0 0 60px rgba(139, 92, 246, 0.1), 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4 font-sans relative overflow-hidden">
    <!-- Background Effects -->
    <div class="fixed inset-0 overflow-hidden pointer-events-none">
        <div class="absolute top-0 right-0 w-[500px] h-[500px] bg-primary/20 rounded-full blur-[120px] animate-pulse"></div>
        <div class="absolute bottom-0 left-0 w-[400px] h-[400px] bg-accent/20 rounded-full blur-[120px] animate-pulse" style="animation-delay: 1s;"></div>
        <div class="absolute top-1/3 left-1/3 w-[300px] h-[300px] bg-purple-600/10 rounded-full blur-[100px]"></div>
    </div>
    
    <div class="relative w-full max-w-md" x-data="{ showPassword: false }">
        <!-- Logo -->
        <div class="text-center mb-8">
            <div class="inline-flex w-20 h-20 rounded-2xl bg-gradient-to-br from-primary via-purple-500 to-purple-600 items-center justify-center text-white text-3xl font-bold mb-4 shadow-2xl shadow-primary/40 ring-4 ring-primary/20">
                H
            </div>
            <h1 class="text-3xl font-bold text-white mb-2">Welcome Back</h1>
            <p class="text-slate-400 text-base">Login ke Admin Panel</p>
        </div>
        
        <!-- Login Card -->
        <div class="bg-dark-200/90 backdrop-blur-2xl rounded-3xl p-8 border border-slate-600/30 card-glow ring-1 ring-white/5">
            <?php if (session()->getFlashdata('error')): ?>
            <div class="mb-6 p-4 rounded-xl bg-red-500/15 border border-red-500/30 text-red-400 flex items-center gap-3 text-sm font-medium">
                <i data-lucide="alert-circle" class="w-5 h-5 flex-shrink-0"></i>
                <span><?= session()->getFlashdata('error') ?></span>
            </div>
            <?php endif; ?>
            
            <?php if (session()->getFlashdata('success')): ?>
            <div class="mb-6 p-4 rounded-xl bg-emerald-500/15 border border-emerald-500/30 text-emerald-400 flex items-center gap-3 text-sm font-medium">
                <i data-lucide="check-circle" class="w-5 h-5 flex-shrink-0"></i>
                <span><?= session()->getFlashdata('success') ?></span>
            </div>
            <?php endif; ?>
            
            <form action="<?= base_url('admin/login') ?>" method="post" class="space-y-6">
                <?= csrf_field() ?>
                
                <!-- Username Field -->
                <div>
                    <label class="block text-sm font-semibold text-slate-200 mb-3">Username atau Email</label>
                    <div class="relative group">
                        <input type="text" 
                               name="username" 
                               value="<?= old('username') ?>"
                               placeholder="Masukkan username"
                               class="w-full px-4 py-3.5 pl-12 rounded-xl bg-dark-300/70 border border-slate-500/40 text-white placeholder-slate-400 focus:outline-none focus:border-primary focus:ring-2 focus:ring-primary/30 transition-all input-glow"
                               required>
                        <i data-lucide="user" class="w-5 h-5 absolute left-4 top-1/2 -translate-y-1/2 text-slate-400 group-focus-within:text-primary transition-colors"></i>
                    </div>
                </div>
                
                <!-- Password Field -->
                <div>
                    <label class="block text-sm font-semibold text-slate-200 mb-3">Password</label>
                    <div class="relative group">
                        <input :type="showPassword ? 'text' : 'password'" 
                               name="password" 
                               placeholder="Masukkan password"
                               class="w-full px-4 py-3.5 pl-12 pr-12 rounded-xl bg-dark-300/70 border border-slate-500/40 text-white placeholder-slate-400 focus:outline-none focus:border-primary focus:ring-2 focus:ring-primary/30 transition-all input-glow"
                               required>
                        <i data-lucide="lock" class="w-5 h-5 absolute left-4 top-1/2 -translate-y-1/2 text-slate-400 group-focus-within:text-primary transition-colors"></i>
                        
                        <!-- Password Toggle Button -->
                        <button type="button" 
                                @click="showPassword = !showPassword"
                                class="absolute right-3 top-1/2 -translate-y-1/2 p-1.5 rounded-lg text-slate-400 hover:text-white hover:bg-slate-600/50 transition-all focus:outline-none focus:ring-2 focus:ring-primary/30"
                                aria-label="Toggle password visibility">
                            <svg x-show="!showPassword" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                <circle cx="12" cy="12" r="3"></circle>
                            </svg>
                            <svg x-show="showPassword" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"></path>
                                <line x1="1" y1="1" x2="23" y2="23"></line>
                            </svg>
                        </button>
                    </div>
                </div>
                
                <!-- Submit Button -->
                <button type="submit" 
                        class="w-full py-4 px-4 rounded-xl bg-gradient-to-r from-primary via-purple-500 to-primary text-white font-bold text-base hover:shadow-2xl hover:shadow-primary/40 transition-all duration-300 flex items-center justify-center gap-2 group btn-shine">
                    <i data-lucide="log-in" class="w-5 h-5 group-hover:translate-x-1 transition-transform"></i>
                    <span>Login</span>
                </button>
            </form>
        </div>
        
        <!-- Back to Website -->
        <div class="text-center mt-8">
            <a href="<?= base_url('/') ?>" class="text-slate-400 hover:text-white transition-colors text-sm font-medium inline-flex items-center gap-2 group">
                <i data-lucide="arrow-left" class="w-4 h-4 group-hover:-translate-x-1 transition-transform"></i>
                Kembali ke Website
            </a>
        </div>
    </div>
    
    <script>
        // Initialize lucide icons when DOM is ready
        document.addEventListener('DOMContentLoaded', () => {
            lucide.createIcons();
        });
    </script>
</body>
</html>
