<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
        <div>
            <h1 class="text-2xl lg:text-3xl font-bold text-white">Pesan Kontak</h1>
            <p class="text-slate-400 mt-1">Pesan dari pengunjung website</p>
        </div>
        <div class="flex items-center gap-3">
            <?php $unreadCount = count(array_filter($messages, fn($m) => !$m['is_read'])); ?>
            <?php if ($unreadCount > 0): ?>
            <div class="flex items-center gap-2 px-4 py-2 rounded-xl bg-amber-500/20 ring-1 ring-amber-500/30">
                <div class="w-2 h-2 rounded-full bg-amber-400 animate-pulse"></div>
                <span class="text-amber-400 font-semibold text-sm"><?= $unreadCount ?> Belum Dibaca</span>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Filters Card -->
    <div class="bg-slate-800/50 backdrop-blur-sm rounded-2xl border border-slate-700/50 p-4 lg:p-6">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
            <!-- Search -->
            <div class="sm:col-span-2">
                <label class="block text-sm font-medium text-slate-300 mb-2">Cari</label>
                <div class="relative">
                    <input type="text" 
                           id="searchInput" 
                           placeholder="Cari nama, email, pesan..." 
                           class="w-full pl-12 pr-4 py-3 rounded-xl border border-slate-600/50 bg-slate-900/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all">
                    <div class="absolute left-4 top-1/2 -translate-y-1/2">
                        <i data-lucide="search" class="w-5 h-5 text-slate-500"></i>
                    </div>
                </div>
            </div>
            
            <!-- Filter Status -->
            <div>
                <label class="block text-sm font-medium text-slate-300 mb-2">Status</label>
                <select id="filterStatus" 
                        class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-slate-900/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all cursor-pointer appearance-none"
                        style="background-image: url('data:image/svg+xml;charset=UTF-8,%3csvg xmlns=%27http://www.w3.org/2000/svg%27 viewBox=%270 0 24 24%27 fill=%27none%27 stroke=%27%2394a3b8%27 stroke-width=%272%27 stroke-linecap=%27round%27 stroke-linejoin=%27round%27%3e%3cpolyline points=%276 9 12 15 18 9%27%3e%3c/polyline%3e%3c/svg%3e'); background-repeat: no-repeat; background-position: right 1rem center; background-size: 1rem;">
                    <option value="">Semua</option>
                    <option value="unread">Belum Dibaca</option>
                    <option value="read">Sudah Dibaca</option>
                </select>
            </div>
            
            <!-- Items Per Page -->
            <div>
                <label class="block text-sm font-medium text-slate-300 mb-2">Tampilkan</label>
                <select id="itemsPerPage" 
                        class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-slate-900/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all cursor-pointer appearance-none"
                        style="background-image: url('data:image/svg+xml;charset=UTF-8,%3csvg xmlns=%27http://www.w3.org/2000/svg%27 viewBox=%270 0 24 24%27 fill=%27none%27 stroke=%27%2394a3b8%27 stroke-width=%272%27 stroke-linecap=%27round%27 stroke-linejoin=%27round%27%3e%3cpolyline points=%276 9 12 15 18 9%27%3e%3c/polyline%3e%3c/svg%3e'); background-repeat: no-repeat; background-position: right 1rem center; background-size: 1rem;">
                    <option value="5">5 data</option>
                    <option value="10" selected>10 data</option>
                    <option value="25">25 data</option>
                    <option value="50">50 data</option>
                </select>
            </div>
        </div>
    </div>
    
    <!-- Messages List -->
    <div class="bg-slate-800/50 backdrop-blur-sm rounded-2xl border border-slate-700/50 overflow-hidden">
        <div id="messagesList" class="divide-y divide-slate-700/30">
            <?php if (empty($messages)): ?>
            <div class="px-6 py-20 text-center">
                <div class="flex flex-col items-center">
                    <div class="w-20 h-20 rounded-2xl bg-slate-700/50 flex items-center justify-center mb-4">
                        <i data-lucide="mail" class="w-10 h-10 text-slate-500"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-slate-300 mb-1">Belum ada pesan</h3>
                    <p class="text-slate-500 text-sm">Pesan dari pengunjung akan muncul di sini</p>
                </div>
            </div>
            <?php else: ?>
            <?php foreach ($messages as $msg): ?>
            <div class="p-4 lg:p-6 hover:bg-slate-700/20 transition-colors data-row <?= !$msg['is_read'] ? 'border-l-4 border-l-primary bg-primary/5' : '' ?>"
                 data-status="<?= $msg['is_read'] ? 'read' : 'unread' ?>"
                 data-search="<?= strtolower(esc($msg['name'] . ' ' . $msg['email'] . ' ' . $msg['message'])) ?>">
                <div class="flex items-start gap-4">
                    <!-- Avatar / Icon -->
                    <div class="w-12 h-12 rounded-xl flex-shrink-0 flex items-center justify-center <?= !$msg['is_read'] ? 'bg-primary/20' : 'bg-slate-700/50' ?>">
                        <?php if (!$msg['is_read']): ?>
                        <i data-lucide="mail" class="w-6 h-6 text-primary"></i>
                        <?php else: ?>
                        <i data-lucide="mail-open" class="w-6 h-6 text-slate-500"></i>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Content -->
                    <div class="flex-1 min-w-0">
                        <div class="flex flex-col lg:flex-row lg:items-start lg:justify-between gap-2 lg:gap-4">
                            <div class="min-w-0 flex-1">
                                <div class="flex items-center gap-2 flex-wrap">
                                    <h4 class="text-white font-semibold"><?= esc($msg['name']) ?></h4>
                                    <?php if (!$msg['is_read']): ?>
                                    <span class="px-2 py-0.5 rounded text-xs font-semibold bg-primary/20 text-primary">Baru</span>
                                    <?php endif; ?>
                                </div>
                                <p class="text-slate-400 text-sm flex items-center gap-1.5 mt-0.5">
                                    <i data-lucide="at-sign" class="w-3.5 h-3.5"></i>
                                    <?= esc($msg['email']) ?>
                                </p>
                                <p class="text-slate-300 mt-3 line-clamp-2 text-sm lg:text-base"><?= esc($msg['message']) ?></p>
                            </div>
                            
                            <div class="flex items-center gap-2 lg:flex-col lg:items-end flex-shrink-0">
                                <span class="text-slate-500 text-sm flex items-center gap-1.5">
                                    <i data-lucide="clock" class="w-3.5 h-3.5"></i>
                                    <?= date('d M Y', strtotime($msg['created_at'])) ?>
                                </span>
                                <span class="text-slate-600 text-xs lg:mt-1"><?= date('H:i', strtotime($msg['created_at'])) ?></span>
                            </div>
                        </div>
                        
                        <!-- Actions -->
                        <div class="flex items-center gap-2 mt-4 pt-4 border-t border-slate-700/30">
                            <a href="<?= base_url('admin/messages/read/' . $msg['id']) ?>" 
                               class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary/10 text-primary hover:bg-primary/20 transition-colors text-sm font-medium">
                                <i data-lucide="eye" class="w-4 h-4"></i>
                                Baca Pesan
                            </a>
                            <a href="mailto:<?= esc($msg['email']) ?>" 
                               class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-slate-700/50 text-slate-300 hover:bg-slate-700 transition-colors text-sm font-medium">
                                <i data-lucide="reply" class="w-4 h-4"></i>
                                Balas
                            </a>
                            <form action="<?= base_url('admin/messages/delete/' . $msg['id']) ?>" method="post" 
                                  onsubmit="return confirm('Yakin ingin menghapus pesan ini?')" class="ml-auto">
                                <?= csrf_field() ?>
                                <button type="submit" 
                                        class="inline-flex items-center gap-2 px-4 py-2 rounded-lg hover:bg-red-500/20 text-slate-400 hover:text-red-400 transition-colors text-sm font-medium">
                                    <i data-lucide="trash-2" class="w-4 h-4"></i>
                                    <span class="hidden sm:inline">Hapus</span>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <!-- No Results -->
        <div id="noResults" class="hidden px-6 py-16 text-center">
            <div class="flex flex-col items-center">
                <div class="w-16 h-16 rounded-2xl bg-slate-700/50 flex items-center justify-center mb-4">
                    <i data-lucide="search-x" class="w-8 h-8 text-slate-500"></i>
                </div>
                <h3 class="text-lg font-semibold text-slate-300 mb-1">Tidak ada hasil</h3>
                <p class="text-slate-500 text-sm">Coba kata kunci lain atau ubah filter</p>
            </div>
        </div>
        
        <!-- Pagination Footer -->
        <div class="px-4 lg:px-6 py-4 border-t border-slate-700/50 flex flex-col sm:flex-row items-center justify-between gap-4">
            <div class="text-sm text-slate-400">
                Menampilkan <span id="showingStart" class="font-semibold text-white">0</span> - <span id="showingEnd" class="font-semibold text-white">0</span> dari <span id="totalItems" class="font-semibold text-white">0</span> pesan
            </div>
            <div id="paginationButtons" class="flex items-center gap-1 flex-wrap justify-center">
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    let currentPage = 1;
    let itemsPerPage = 10;
    let filteredRows = [];
    
    const searchInput = document.getElementById('searchInput');
    const filterStatus = document.getElementById('filterStatus');
    const itemsPerPageSelect = document.getElementById('itemsPerPage');
    const messagesList = document.getElementById('messagesList');
    const noResults = document.getElementById('noResults');
    const paginationButtons = document.getElementById('paginationButtons');
    const showingStart = document.getElementById('showingStart');
    const showingEnd = document.getElementById('showingEnd');
    const totalItems = document.getElementById('totalItems');
    
    const allRows = Array.from(messagesList?.querySelectorAll('.data-row') || []);
    
    function filterTable() {
        const searchTerm = searchInput.value.toLowerCase();
        const selectedStatus = filterStatus.value;
        
        filteredRows = allRows.filter(row => {
            const searchData = row.getAttribute('data-search');
            const statusData = row.getAttribute('data-status');
            
            const matchesSearch = searchData.includes(searchTerm);
            const matchesStatus = !selectedStatus || statusData === selectedStatus;
            
            return matchesSearch && matchesStatus;
        });
        
        currentPage = 1;
        renderTable();
    }
    
    function renderTable() {
        const totalFiltered = filteredRows.length;
        const totalPages = Math.ceil(totalFiltered / itemsPerPage);
        const startIndex = (currentPage - 1) * itemsPerPage;
        const endIndex = Math.min(startIndex + itemsPerPage, totalFiltered);
        
        allRows.forEach(row => row.style.display = 'none');
        
        for (let i = startIndex; i < endIndex; i++) {
            filteredRows[i].style.display = '';
        }
        
        showingStart.textContent = totalFiltered > 0 ? startIndex + 1 : 0;
        showingEnd.textContent = endIndex;
        totalItems.textContent = totalFiltered;
        
        if (totalFiltered === 0 && allRows.length > 0) {
            noResults.classList.remove('hidden');
        } else {
            noResults.classList.add('hidden');
        }
        
        renderPagination(totalPages);
    }
    
    function renderPagination(totalPages) {
        paginationButtons.innerHTML = '';
        
        if (totalPages <= 1) return;
        
        const prevBtn = createPaginationBtn('chevron-left', currentPage > 1);
        prevBtn.onclick = () => currentPage > 1 && goToPage(currentPage - 1);
        paginationButtons.appendChild(prevBtn);
        
        const maxVisible = window.innerWidth < 640 ? 3 : 5;
        let startPage = Math.max(1, currentPage - Math.floor(maxVisible / 2));
        let endPage = Math.min(totalPages, startPage + maxVisible - 1);
        
        if (endPage - startPage + 1 < maxVisible) {
            startPage = Math.max(1, endPage - maxVisible + 1);
        }
        
        if (startPage > 1) {
            paginationButtons.appendChild(createPageBtn(1));
            if (startPage > 2) {
                const dots = document.createElement('span');
                dots.className = 'px-2 text-slate-600';
                dots.textContent = '...';
                paginationButtons.appendChild(dots);
            }
        }
        
        for (let i = startPage; i <= endPage; i++) {
            paginationButtons.appendChild(createPageBtn(i, i === currentPage));
        }
        
        if (endPage < totalPages) {
            if (endPage < totalPages - 1) {
                const dots = document.createElement('span');
                dots.className = 'px-2 text-slate-600';
                dots.textContent = '...';
                paginationButtons.appendChild(dots);
            }
            paginationButtons.appendChild(createPageBtn(totalPages));
        }
        
        const nextBtn = createPaginationBtn('chevron-right', currentPage < totalPages);
        nextBtn.onclick = () => currentPage < totalPages && goToPage(currentPage + 1);
        paginationButtons.appendChild(nextBtn);
        
        lucide.createIcons();
    }
    
    function createPaginationBtn(icon, enabled) {
        const btn = document.createElement('button');
        btn.className = `w-9 h-9 flex items-center justify-center rounded-lg transition-all ${enabled ? 'text-slate-300 hover:bg-slate-700' : 'text-slate-600 cursor-not-allowed'}`;
        btn.innerHTML = `<i data-lucide="${icon}" class="w-4 h-4"></i>`;
        btn.disabled = !enabled;
        return btn;
    }
    
    function createPageBtn(page, isActive = false) {
        const btn = document.createElement('button');
        btn.className = `min-w-[2.25rem] h-9 px-3 flex items-center justify-center rounded-lg font-medium text-sm transition-all ${isActive ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'text-slate-300 hover:bg-slate-700'}`;
        btn.textContent = page;
        btn.onclick = () => goToPage(page);
        return btn;
    }
    
    function goToPage(page) {
        currentPage = page;
        renderTable();
        window.scrollTo({ top: 0, behavior: 'smooth' });
    }
    
    searchInput?.addEventListener('input', filterTable);
    filterStatus?.addEventListener('change', filterTable);
    itemsPerPageSelect?.addEventListener('change', (e) => {
        itemsPerPage = parseInt(e.target.value);
        currentPage = 1;
        filterTable();
    });
    
    filteredRows = [...allRows];
    renderTable();
    lucide.createIcons();
</script>
<?= $this->endSection() ?>
