<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<div class="max-w-3xl">
    <a href="<?= base_url('admin/messages') ?>" class="inline-flex items-center gap-2 text-slate-300 hover:text-primary transition-colors mb-6">
        <i data-lucide="arrow-left" class="w-5 h-5"></i>
        Kembali ke Daftar Pesan
    </a>
    
    <div class="card p-6">
        <div class="flex items-start gap-4 mb-6 pb-6 border-b border-slate-700/50">
            <div class="w-12 h-12 rounded-full bg-primary/20 flex items-center justify-center flex-shrink-0 ring-2 ring-primary/30">
                <i data-lucide="user" class="w-6 h-6 text-primary"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold text-white"><?= esc($message['name']) ?></h2>
                <a href="mailto:<?= esc($message['email']) ?>" class="text-primary hover:text-primary/80 transition-colors"><?= esc($message['email']) ?></a>
                <p class="text-sm text-slate-400 mt-1 flex items-center gap-1">
                    <i data-lucide="clock" class="w-4 h-4"></i>
                    <?= date('d F Y, H:i', strtotime($message['created_at'])) ?>
                </p>
            </div>
        </div>
        
        <div class="prose max-w-none">
            <p class="text-slate-200 whitespace-pre-wrap leading-relaxed text-base"><?= esc($message['message']) ?></p>
        </div>
        
        <div class="flex gap-3 mt-8 pt-6 border-t border-slate-700/50">
            <a href="mailto:<?= esc($message['email']) ?>" class="px-5 py-2.5 rounded-xl bg-gradient-to-r from-primary to-purple-600 text-white font-medium hover:shadow-lg hover:shadow-primary/30 transition-all inline-flex items-center gap-2">
                <i data-lucide="reply" class="w-5 h-5"></i>
                Balas via Email
            </a>
            <form action="<?= base_url('admin/messages/delete/' . $message['id']) ?>" method="post" onsubmit="return confirm('Yakin ingin menghapus pesan ini?')">
                <?= csrf_field() ?>
                <button type="submit" class="px-5 py-2.5 rounded-xl bg-danger/20 text-danger hover:bg-danger/30 transition-all font-medium inline-flex items-center gap-2 ring-1 ring-danger/30">
                    <i data-lucide="trash-2" class="w-5 h-5"></i>
                    Hapus
                </button>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
