<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header -->
<div class="mb-6">
    <h2 class="text-2xl font-bold text-white">Pengaturan Website</h2>
    <p class="text-sm text-slate-300 mt-1">Kelola pengaturan dan konfigurasi website</p>
</div>

<div class="card p-6 max-w-3xl">
    <form action="<?= base_url('admin/settings/update') ?>" method="post" enctype="multipart/form-data" class="space-y-6">
        <?= csrf_field() ?>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Judul Website</label>
            <input type="text" name="site_title" value="<?= esc($settings['site_title'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Hanif - Portfolio">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Deskripsi Website</label>
            <input type="text" name="site_description" value="<?= esc($settings['site_description'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Portfolio profesional saya">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Meta Description (SEO)</label>
            <textarea name="meta_description" rows="3" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none resize-none transition-all" placeholder="Deskripsi singkat website untuk mesin pencari..."><?= esc($settings['meta_description'] ?? '') ?></textarea>
            <p class="text-xs text-slate-400 mt-1">Deskripsi yang muncul di hasil pencarian Google (maks. 160 karakter)</p>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Footer Text</label>
            <input type="text" name="footer_text" value="<?= esc($settings['footer_text'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="© 2024 Nama. All rights reserved.">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">OG Image (untuk share social media)</label>
            <?php if (!empty($settings['og_image'])): ?>
            <div class="mb-3">
                <img src="<?= media_url($settings['og_image']) ?>" alt="" class="w-40 h-auto object-cover rounded-lg ring-1 ring-slate-600">
            </div>
            <?php endif; ?>
            <input type="file" name="og_image" accept="image/*" class="text-sm text-slate-300 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary/20 file:text-primary hover:file:bg-primary/30 file:transition-colors file:cursor-pointer cursor-pointer">
            <p class="text-xs text-slate-400 mt-1">Rekomendasi ukuran: 1200x630 pixels</p>
        </div>
        
        <div class="flex justify-end pt-6 border-t border-slate-700/50">
            <button type="submit" class="px-6 py-3 rounded-xl bg-gradient-to-r from-primary to-purple-600 text-white font-medium hover:shadow-lg hover:shadow-primary/30 transition-all flex items-center gap-2">
                <i data-lucide="save" class="w-5 h-5"></i>
                Simpan Pengaturan
            </button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>
