<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>

<section class="min-h-screen flex items-center justify-center pt-20">
    <div class="max-w-xl mx-auto px-4 text-center">
        <!-- 404 Illustration -->
        <div class="mb-8 reveal">
            <div class="relative inline-block">
                <div class="text-[150px] lg:text-[200px] font-bold gradient-text leading-none">
                    404
                </div>
                <div class="absolute inset-0 text-[150px] lg:text-[200px] font-bold text-primary/10 blur-2xl leading-none">
                    404
                </div>
            </div>
        </div>
        
        <h1 class="text-3xl lg:text-4xl font-bold dark:text-white text-gray-900 mb-4 reveal">
            Halaman Tidak Ditemukan
        </h1>
        
        <p class="dark:text-white/60 text-gray-600 mb-8 reveal">
            Maaf, halaman yang Anda cari tidak ada atau telah dipindahkan. 
            Mari kembali ke halaman utama.
        </p>
        
        <div class="flex flex-wrap gap-4 justify-center reveal">
            <a href="<?= base_url('/') ?>" class="btn-primary flex items-center gap-2">
                <i data-lucide="home" class="w-5 h-5"></i>
                Kembali ke Home
            </a>
            <a href="<?= base_url('kontak') ?>" class="btn-secondary flex items-center gap-2 dark:text-white text-gray-700">
                <i data-lucide="mail" class="w-5 h-5"></i>
                Hubungi Kami
            </a>
        </div>
        
        <!-- Popular Links -->
        <div class="mt-12 reveal">
            <p class="text-sm dark:text-white/40 text-gray-500 mb-4">Atau kunjungi halaman populer:</p>
            <div class="flex flex-wrap gap-3 justify-center">
                <a href="<?= base_url('biodata') ?>" class="px-4 py-2 rounded-lg dark:bg-white/10 bg-gray-100 dark:text-white/70 text-gray-600 hover:text-primary transition-colors text-sm">
                    Biodata
                </a>
                <a href="<?= base_url('aktivitas') ?>" class="px-4 py-2 rounded-lg dark:bg-white/10 bg-gray-100 dark:text-white/70 text-gray-600 hover:text-primary transition-colors text-sm">
                    Aktivitas
                </a>
                <a href="<?= base_url('pendidikan') ?>" class="px-4 py-2 rounded-lg dark:bg-white/10 bg-gray-100 dark:text-white/70 text-gray-600 hover:text-primary transition-colors text-sm">
                    Pendidikan
                </a>
            </div>
        </div>
    </div>
</section>

<?= $this->endSection() ?>
