<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>

<!-- Page Header -->
<section class="pt-32 pb-16 relative">
    <div class="blob blob-1 opacity-20"></div>
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="text-center reveal">
            <h1 class="text-4xl lg:text-5xl font-bold dark:text-white text-gray-900 mb-4">
                <span class="gradient-text">Aktivitas</span>
            </h1>
            <p class="dark:text-white/60 text-gray-600 max-w-xl mx-auto">
                Project, kegiatan, dan prestasi yang telah saya capai
            </p>
        </div>
    </div>
</section>

<!-- Filter & Search -->
<section class="pb-8 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="flex flex-col md:flex-row gap-4 items-center justify-between reveal">
            <!-- Category Filter -->
            <div class="flex flex-wrap gap-2">
                <a href="<?= base_url('aktivitas') ?>" 
                   class="px-4 py-2 rounded-xl text-sm font-medium transition-colors <?= empty($currentCategory) ? 'bg-primary text-white' : 'dark:bg-white/10 bg-gray-100 dark:text-white text-gray-700 hover:bg-primary/20' ?>">
                    Semua
                </a>
                <?php foreach ($categories as $cat): ?>
                <a href="<?= base_url('aktivitas?category=' . urlencode($cat['category'])) ?>" 
                   class="px-4 py-2 rounded-xl text-sm font-medium transition-colors <?= $currentCategory === $cat['category'] ? 'bg-primary text-white' : 'dark:bg-white/10 bg-gray-100 dark:text-white text-gray-700 hover:bg-primary/20' ?>">
                    <?= esc($cat['category']) ?>
                </a>
                <?php endforeach; ?>
            </div>
            
            <!-- Search -->
            <form action="<?= base_url('aktivitas') ?>" method="get" class="w-full md:w-auto">
                <div class="relative">
                    <input type="text" 
                           name="search" 
                           value="<?= esc($searchQuery ?? '') ?>"
                           placeholder="Cari aktivitas..."
                           class="w-full md:w-64 px-4 py-2 pl-10 rounded-xl dark:bg-white/10 bg-gray-100 dark:text-white text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary/50 border-0">
                    <i data-lucide="search" class="w-5 h-5 absolute left-3 top-1/2 -translate-y-1/2 dark:text-white/40 text-gray-400"></i>
                </div>
            </form>
        </div>
    </div>
</section>

<!-- Activities Timeline -->
<section class="py-8 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <?php if (empty($activities)): ?>
        <div class="text-center py-16 reveal">
            <i data-lucide="folder-open" class="w-16 h-16 mx-auto dark:text-white/20 text-gray-300 mb-4"></i>
            <h3 class="text-xl font-semibold dark:text-white text-gray-900 mb-2">Tidak ada aktivitas</h3>
            <p class="dark:text-white/60 text-gray-600">Belum ada aktivitas yang tersedia.</p>
        </div>
        <?php else: ?>
        <div class="relative pl-8 lg:pl-0">
            <!-- Timeline Line (Mobile) -->
            <div class="timeline-line lg:hidden"></div>
            
            <div class="space-y-8 stagger-container">
                <?php foreach ($activities as $index => $activity): ?>
                <div class="relative stagger-item">
                    <!-- Timeline Dot (Mobile) -->
                    <div class="timeline-dot top-6 lg:hidden"></div>
                    
                    <a href="<?= base_url('aktivitas/' . $activity['slug']) ?>" class="block ml-8 lg:ml-0">
                        <div class="card overflow-hidden group hover:glow-hover transition-all duration-300">
                            <div class="flex flex-col lg:flex-row">
                                <!-- Thumbnail -->
                                <div class="lg:w-80 h-48 lg:h-auto flex-shrink-0 overflow-hidden bg-gradient-to-br from-primary/20 to-accent/20">
                                    <?php if (!empty($activity['thumbnail'])): ?>
                                        <img src="<?= media_url($activity['thumbnail']) ?>" 
                                             alt="<?= esc($activity['title']) ?>" 
                                             class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                                             loading="lazy">
                                    <?php else: ?>
                                        <div class="w-full h-full flex items-center justify-center">
                                            <i data-lucide="image" class="w-12 h-12 text-primary/50"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Content -->
                                <div class="flex-1 p-6">
                                    <div class="flex items-center gap-3 mb-3">
                                        <?php if (!empty($activity['category'])): ?>
                                        <span class="tag"><?= esc($activity['category']) ?></span>
                                        <?php endif; ?>
                                        <span class="text-sm dark:text-white/40 text-gray-500">
                                            <i data-lucide="calendar" class="w-4 h-4 inline-block mr-1"></i>
                                            <?= format_date($activity['activity_date'], 'd F Y') ?>
                                        </span>
                                    </div>
                                    
                                    <h2 class="text-xl font-bold dark:text-white text-gray-900 mb-3 group-hover:text-primary transition-colors">
                                        <?= esc($activity['title']) ?>
                                    </h2>
                                    
                                    <p class="dark:text-white/60 text-gray-600 mb-4 line-clamp-2">
                                        <?= excerpt($activity['content'], 150) ?>
                                    </p>
                                    
                                    <!-- Tags -->
                                    <?php if (!empty($activity['tags'])): ?>
                                    <div class="flex flex-wrap gap-2 mb-4">
                                        <?php foreach (array_slice($activity['tags'], 0, 4) as $tag): ?>
                                        <span class="text-xs px-2 py-1 rounded-md dark:bg-white/5 bg-gray-100 dark:text-white/60 text-gray-600">
                                            <?= esc($tag) ?>
                                        </span>
                                        <?php endforeach; ?>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <span class="inline-flex items-center gap-2 text-primary font-medium group-hover:gap-3 transition-all">
                                        Baca Selengkapnya
                                        <i data-lucide="arrow-right" class="w-4 h-4"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</section>

<?= $this->endSection() ?>
