<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>

<!-- Page Header -->
<section class="pt-32 pb-16 relative">
    <div class="blob blob-1 opacity-20"></div>
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="text-center reveal">
            <h1 class="text-4xl lg:text-5xl font-bold dark:text-white text-gray-900 mb-4">
                <span class="gradient-text">Kontak</span>
            </h1>
            <p class="dark:text-white/60 text-gray-600 max-w-xl mx-auto">
                Hubungi saya untuk kolaborasi, pertanyaan, atau sekadar menyapa
            </p>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section class="py-8 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-8">
            <!-- Contact Info -->
            <div class="reveal">
                <h2 class="text-2xl font-bold dark:text-white text-gray-900 mb-6">
                    Mari Terhubung
                </h2>
                <p class="dark:text-white/60 text-gray-600 mb-8 leading-relaxed">
                    Saya selalu terbuka untuk diskusi tentang project baru, peluang kreatif, atau sekadar berbagi ide. Jangan ragu untuk menghubungi saya!
                </p>
                
                <div class="space-y-4">
                    <?php 
                    $biodata = (new \App\Models\BiodataModel())->getBiodata();
                    ?>
                    
                    <?php if (!empty($biodata['email'])): ?>
                    <a href="mailto:<?= esc($biodata['email']) ?>" class="card p-4 flex items-center gap-4 group hover:border-primary/30 transition-colors">
                        <div class="w-12 h-12 rounded-xl bg-primary/20 flex items-center justify-center">
                            <i data-lucide="mail" class="w-6 h-6 text-primary"></i>
                        </div>
                        <div>
                            <p class="text-sm dark:text-white/40 text-gray-500">Email</p>
                            <p class="font-medium dark:text-white text-gray-900 group-hover:text-primary transition-colors">
                                <?= esc($biodata['email']) ?>
                            </p>
                        </div>
                    </a>
                    <?php endif; ?>
                    
                    <?php if (!empty($biodata['phone'])): ?>
                    <div class="card p-4 flex items-center gap-4">
                        <div class="w-12 h-12 rounded-xl bg-accent/20 flex items-center justify-center">
                            <i data-lucide="phone" class="w-6 h-6 text-accent"></i>
                        </div>
                        <div>
                            <p class="text-sm dark:text-white/40 text-gray-500">Telepon</p>
                            <p class="font-medium dark:text-white text-gray-900">
                                <?= esc($biodata['phone']) ?>
                            </p>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($biodata['location'])): ?>
                    <div class="card p-4 flex items-center gap-4">
                        <div class="w-12 h-12 rounded-xl bg-success/20 flex items-center justify-center">
                            <i data-lucide="map-pin" class="w-6 h-6 text-success"></i>
                        </div>
                        <div>
                            <p class="text-sm dark:text-white/40 text-gray-500">Lokasi</p>
                            <p class="font-medium dark:text-white text-gray-900">
                                <?= esc($biodata['location']) ?>
                            </p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- Social Links -->
                <div class="mt-8">
                    <p class="text-sm dark:text-white/40 text-gray-500 mb-4">Follow me on social media</p>
                    <div class="flex gap-3">
                        <?php if (!empty($biodata['socials']['github'])): ?>
                        <a href="<?= esc($biodata['socials']['github']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="github" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['linkedin'])): ?>
                        <a href="<?= esc($biodata['socials']['linkedin']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="linkedin" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['twitter'])): ?>
                        <a href="<?= esc($biodata['socials']['twitter']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="twitter" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['instagram'])): ?>
                        <a href="<?= esc($biodata['socials']['instagram']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="instagram" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Contact Form -->
            <div class="reveal">
                <div class="card p-8">
                    <h3 class="text-xl font-bold dark:text-white text-gray-900 mb-6">
                        Kirim Pesan
                    </h3>
                    
                    <form id="contactForm" x-data="contactForm()" @submit.prevent="submit()" class="space-y-6">
                        <?= csrf_field() ?>
                        
                        <div>
                            <label class="block text-sm font-medium dark:text-white/80 text-gray-700 mb-2">
                                Nama Lengkap
                            </label>
                            <input type="text" 
                                   name="name" 
                                   x-model="form.name"
                                   placeholder="Masukkan nama Anda"
                                   class="w-full px-4 py-3 rounded-xl dark:bg-white/10 bg-gray-100 dark:text-white text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary/50 border-0"
                                   required>
                            <p x-show="errors.name" x-text="errors.name" class="mt-1 text-sm text-danger"></p>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium dark:text-white/80 text-gray-700 mb-2">
                                Email
                            </label>
                            <input type="email" 
                                   name="email" 
                                   x-model="form.email"
                                   placeholder="email@example.com"
                                   class="w-full px-4 py-3 rounded-xl dark:bg-white/10 bg-gray-100 dark:text-white text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary/50 border-0"
                                   required>
                            <p x-show="errors.email" x-text="errors.email" class="mt-1 text-sm text-danger"></p>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium dark:text-white/80 text-gray-700 mb-2">
                                Pesan
                            </label>
                            <textarea name="message" 
                                      x-model="form.message"
                                      rows="5"
                                      placeholder="Tulis pesan Anda..."
                                      class="w-full px-4 py-3 rounded-xl dark:bg-white/10 bg-gray-100 dark:text-white text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary/50 border-0 resize-none"
                                      required></textarea>
                            <p x-show="errors.message" x-text="errors.message" class="mt-1 text-sm text-danger"></p>
                        </div>
                        
                        <button type="submit" 
                                :disabled="loading"
                                class="btn-primary w-full flex items-center justify-center gap-2 disabled:opacity-50 disabled:cursor-not-allowed">
                            <span x-show="!loading">
                                <i data-lucide="send" class="w-5 h-5 inline-block mr-2"></i>
                                Kirim Pesan
                            </span>
                            <span x-show="loading" class="flex items-center gap-2">
                                <svg class="animate-spin h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                Mengirim...
                            </span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function contactForm() {
        return {
            form: {
                name: '',
                email: '',
                message: ''
            },
            errors: {},
            loading: false,
            
            async submit() {
                this.loading = true;
                this.errors = {};
                
                try {
                    const formData = new FormData();
                    formData.append('<?= csrf_token() ?>', '<?= csrf_hash() ?>');
                    formData.append('name', this.form.name);
                    formData.append('email', this.form.email);
                    formData.append('message', this.form.message);
                    
                    const response = await fetch('<?= base_url('kontak/send') ?>', {
                        method: 'POST',
                        body: formData
                    });
                    
                    const data = await response.json();
                    
                    if (data.success) {
                        showToast(data.message, 'success');
                        this.form = { name: '', email: '', message: '' };
                    } else {
                        if (data.errors) {
                            this.errors = data.errors;
                        } else {
                            showToast(data.message || 'Terjadi kesalahan', 'error');
                        }
                    }
                } catch (error) {
                    showToast('Gagal mengirim pesan. Silakan coba lagi.', 'error');
                } finally {
                    this.loading = false;
                }
            }
        }
    }
</script>
<?= $this->endSection() ?>
