<?php
// Full error check
error_reporting(E_ALL);
ini_set('display_errors', 1);

function checkUrl($url, $name) {
    echo "=== Checking $name ($url) ===\n";
    $context = stream_context_create(['http' => ['timeout' => 10]]);
    $response = @file_get_contents($url, false, $context);
    
    if ($response === false) {
        echo "  FAILED: Could not connect\n\n";
        return;
    }
    
    // Check if it's an actual error page
    if (preg_match('/ErrorException|DatabaseException|ParseError|RuntimeException|CodeIgniter.+Exception/i', $response, $match)) {
        echo "  ERROR TYPE: " . $match[0] . "\n";
        
        // Get the message
        if (preg_match('/<p class="lead"[^>]*>(.*?)<\/p>/s', $response, $msg)) {
            echo "  MESSAGE: " . trim(strip_tags($msg[1])) . "\n";
        }
        
        // Get file
        if (preg_match('/APPPATH.+\.php|SYSTEMPATH.+\.php/s', $response, $file)) {
            echo "  FILE: " . strip_tags($file[0]) . "\n";
        }
    } else {
        echo "  OK - Page loaded (" . strlen($response) . " bytes)\n";
        
        // Show some content
        preg_match('/<title>(.*?)<\/title>/s', $response, $title);
        echo "  Title: " . strip_tags($title[1] ?? 'No title') . "\n";
    }
    echo "\n";
}

checkUrl('http://localhost:8080/', 'Home');
checkUrl('http://localhost:8080/biodata', 'Biodata');
checkUrl('http://localhost:8080/aktivitas', 'Aktivitas');
checkUrl('http://localhost:8080/admin/login', 'Admin Login');
