<?php

namespace App\Controllers;

use App\Models\DailyActivityModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Activities extends BaseController
{
	public function index()
	{
		$model = new DailyActivityModel();
		
		// Get search parameter
		$search = $this->request->getGet('search');
		
		// Get filter parameters
		$filter_tanggal = $this->request->getGet('filter_tanggal');
		
		// Get sorting parameters
		$sort_by = $this->request->getGet('sort_by') ?? 'tanggal';
		$sort_order = $this->request->getGet('sort_order') ?? 'DESC';
		
		// Build query using model methods
		// Apply search
		if (!empty($search)) {
			$model->like('nama_aktivitas', $search);
		}
		
		// Apply filter
		if (!empty($filter_tanggal)) {
			$model->where('tanggal', $filter_tanggal);
		}
		
		// Apply sorting
		$model->orderBy($sort_by, $sort_order);
		
		// Get paginated results (10 per page)
		$data = [
			'activities' => $model->paginate(10),
			'pager' => $model->pager,
			'search' => $search,
			'filter_tanggal' => $filter_tanggal,
			'sort_by' => $sort_by,
			'sort_order' => $sort_order,
		];
		
		echo view('activities', $data);
	}
}

