<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Edit Biodata</h1>
</div>

<div class="admin-card">
<form action="" method="post" enctype="multipart/form-data">
    <input type="hidden" name="id" value="<?= $biodata['id'] ?>">
    
    <div class="admin-form-group">
        <label for="nama">Nama *</label>
        <input type="text" name="nama" class="admin-form-control" value="<?= esc($biodata['nama']) ?>" required>
    </div>
    <div class="admin-form-group">
        <label for="alamat">Alamat</label>
        <textarea name="alamat" class="admin-form-control" rows="3"><?= esc($biodata['alamat']) ?></textarea>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="tempat_lahir">Tempat Lahir</label>
                <input type="text" name="tempat_lahir" class="admin-form-control" value="<?= esc($biodata['tempat_lahir']) ?>">
            </div>
        </div>
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="tanggal_lahir">Tanggal Lahir</label>
                <input type="date" name="tanggal_lahir" class="admin-form-control" value="<?= $biodata['tanggal_lahir'] ?>">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="jenis_kelamin">Jenis Kelamin</label>
                <select name="jenis_kelamin" class="admin-form-control">
                    <option value="">Pilih</option>
                    <option value="Laki-laki" <?= $biodata['jenis_kelamin'] == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= $biodata['jenis_kelamin'] == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
        </div>
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="agama">Agama</label>
                <input type="text" name="agama" class="admin-form-control" value="<?= esc($biodata['agama']) ?>">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="no_hp">No. HP</label>
                <input type="text" name="no_hp" class="admin-form-control" value="<?= esc($biodata['no_hp']) ?>">
            </div>
        </div>
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="email">Email</label>
                <input type="email" name="email" class="admin-form-control" value="<?= esc($biodata['email']) ?>">
            </div>
        </div>
    </div>
    <div class="admin-form-group">
        <label for="foto_profil">Foto Profil</label>
        <?php if (!empty($biodata['foto_profil'])): ?>
            <div class="mb-2">
                <img src="<?= base_url($biodata['foto_profil']) ?>" style="max-width: 200px; max-height: 200px;" alt="Foto saat ini">
                <p class="text-muted">Foto saat ini</p>
            </div>
        <?php endif; ?>
        <input type="file" name="foto_profil" class="admin-form-control" accept="image/*">
        <small class="text-muted d-block mt-1">Kosongkan jika tidak ingin mengubah foto</small>
    </div>
    <div class="admin-form-group">
        <label for="deskripsi">Deskripsi</label>
        <textarea name="deskripsi" class="admin-form-control" rows="5"><?= esc($biodata['deskripsi']) ?></textarea>
    </div>
    <div class="admin-form-group d-flex gap-2">
        <button type="submit" class="admin-btn admin-btn-primary">Update</button>
        <a href="<?= base_url('admin/biodata') ?>" class="admin-btn admin-btn-secondary">Batal</a>
    </div>
</form>
</div>

<?= $this->endSection() ?>







