<?php

/**
 * Script untuk debug aktivitas save dengan simulasi POST request
 */

echo "=== Debug Aktivitas Save ===\n\n";

// Simulate POST data
$_POST = [
    'tanggal' => date('Y-m-d'),
    'nama_aktivitas' => 'Debug Test Activity - ' . date('H:i:s'),
    'keterangan' => 'This is a debug test created at ' . date('Y-m-d H:i:s')
];

$_SERVER['REQUEST_METHOD'] = 'POST';

echo "Simulated POST data:\n";
print_r($_POST);
echo "\n";

// Load CodeIgniter
define('FCPATH', __DIR__ . DIRECTORY_SEPARATOR . 'public' . DIRECTORY_SEPARATOR);

// Bootstrap the application
require FCPATH . '../app/Config/Paths.php';
$paths = new Config\Paths();

require FCPATH . '../vendor/autoload.php';

// Load environment
$bootstrap = require FCPATH . '../app/Config/Bootstrap.php';

// Get database connection
$db = \Config\Database::connect();

echo "Database connection: ";
if ($db->connID) {
    echo "✓ Connected\n\n";
} else {
    echo "✗ Failed\n\n";
    exit(1);
}

// Test 1: Check if table exists
echo "Test 1: Check table structure\n";
echo "------------------------------\n";
$query = $db->query("DESCRIBE aktivitas");
$fields = $query->getResultArray();

foreach ($fields as $field) {
    echo "- {$field['Field']}: {$field['Type']}\n";
}
echo "\n";

// Test 2: Try to use the model
echo "Test 2: Test AktivitasModel\n";
echo "----------------------------\n";

try {
    $model = new \App\Models\AktivitasModel();
    
    echo "Model loaded successfully\n";
    echo "Table: " . $model->getTable() . "\n";
    echo "Allowed fields: " . implode(', ', $model->getAllowedFields()) . "\n";
    echo "Validation rules: " . json_encode($model->getValidationRules()) . "\n\n";
    
    // Test 3: Try to save data
    echo "Test 3: Attempt to save data\n";
    echo "-----------------------------\n";
    
    $data = [
        'tanggal' => $_POST['tanggal'],
        'nama_aktivitas' => $_POST['nama_aktivitas'],
        'keterangan' => $_POST['keterangan']
    ];
    
    echo "Data to save:\n";
    print_r($data);
    echo "\n";
    
    // Validate first
    if (!$model->validate($data)) {
        echo "✗ Validation failed:\n";
        print_r($model->errors());
        echo "\n";
    } else {
        echo "✓ Validation passed\n\n";
        
        // Try to save
        $result = $model->save($data);
        
        if ($result) {
            $insertId = $model->getInsertID();
            echo "✓ Save successful! Insert ID: $insertId\n";
            
            // Verify the data was saved
            $saved = $model->find($insertId);
            echo "\nSaved data:\n";
            print_r($saved);
        } else {
            echo "✗ Save failed\n";
            echo "Errors: " . json_encode($model->errors()) . "\n";
        }
    }
    
} catch (\Exception $e) {
    echo "✗ Exception: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n=== Debug Complete ===\n";
