<?php

namespace Config;

$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

$routes->get('/', 'Home::index');
$routes->get('/news', 'News::index');
$routes->get('/about', 'Page::about');
$routes->get('/contact', 'Page::contact');
$routes->post('/contact', 'Page::contact');
$routes->get('/faqs', 'Page::faqs');
$routes->get('/news/(:any)', 'News::viewNews/$1');

/*
 * --------------------------------------------------------------------
 * ADMIN GROUP
 * --------------------------------------------------------------------
 */
$routes->group('admin', function($routes){
    // News Admin
    $routes->get('news', 'NewsAdmin::index');
    $routes->get('news/(:segment)/preview', 'NewsAdmin::preview/$1');
    $routes->add('news/new', 'NewsAdmin::create');
    $routes->add('news/(:segment)/edit', 'NewsAdmin::edit/$1');
    $routes->get('news/(:segment)/delete', 'NewsAdmin::delete/$1');

    // Dashboard
    $routes->get('dashboard', 'AdminDashboard::index');

    // Pegawai Admin
    $routes->group('pegawai', function($routes){
        $routes->get('/', 'Admin\Pegawai::index');
        $routes->get('create', 'Admin\Pegawai::create');
        $routes->post('store', 'Admin\Pegawai::store');
        $routes->get('preview/(:num)', 'Admin\Pegawai::preview/$1');
        $routes->get('edit/(:num)', 'Admin\Pegawai::edit/$1');
        $routes->post('update/(:num)', 'Admin\Pegawai::update/$1');
        $routes->get('delete/(:num)', 'Admin\Pegawai::delete/$1');

    });
});

// Setup Admin
$routes->get('/setup-admin', 'SetupAdmin::index');

// LOGIN ADMIN
$routes->get('/admin/login', 'AdminLogin::index');
$routes->post('/admin/login', 'AdminLogin::auth');
$routes->get('/admin/logout', 'AdminLogin::logout');
$routes->get('/auth/logout', 'Admin\Auth::logout');

$routes->get('admin/setting', 'Admin\Setting::index');

/*
 * --------------------------------------------------------------------
 * FRONTEND PEGAWAI
 * --------------------------------------------------------------------
 */
$routes->get('/pegawai', 'PegawaiPublic::index');
$routes->get('/list-pegawai', 'PegawaiPublic::index'); // alias optional
