<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\PegawaiModel;

class PegawaiPublic extends BaseController
{
    protected $pegawai;

    public function __construct()
    {
        $this->pegawai = new PegawaiModel();
    }

    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $gender  = $this->request->getGet('gender');

        // Mulai builder
        $builder = $this->pegawai;

        // FILTER PENCARIAN
        if ($keyword) {
            $builder->like('nama_pegawai', $keyword)
                    ->orLike('jenis_kelamin', $keyword)
                    ->orLike('divisi', $keyword);
        }

        // FILTER GENDER
        if ($gender) {
            $builder->where('jenis_kelamin', $gender);
        }

        // KIRIM DATA KE VIEW
        $data = [
            'pegawai' => $builder->findAll(),  // FIX: nama variabel harus 'pegawai'
            'keyword' => $keyword,
            'gender'  => $gender
        ];

        return view('frontend/index', $data);
    }
}
