<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="card p-4 shadow mb-4" style="border-radius: 15px; border: none;">

    <!-- HEADER FORM -->
    <div style="
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 1.3rem;
        border-radius: 12px;
        color: white;
        font-weight: 700;
        font-size: 1.3rem;
        display: flex;
        align-items: center;
        gap: 10px;
    ">
        <i class="bi bi-pencil-square" style="font-size: 1.7rem;"></i>
        <span>Edit Pegawai</span>
    </div>

    <!-- FORM EDIT -->
    <form action="<?= base_url('admin/pegawai/update/'.$pegawai['id_pegawai']) ?>" method="post" enctype="multipart/form-data" class="mt-4">

        <!-- Nama Pegawai -->
        <div class="mb-3">
            <label for="nama_pegawai" class="form-label fw-bold">Nama Pegawai</label>
            <input type="text" name="nama_pegawai" id="nama_pegawai" class="form-control" value="<?= esc($pegawai['nama_pegawai']) ?>" required>
        </div>

        <!-- Tanggal Lahir -->
        <div class="mb-3">
            <label for="tanggal_lahir" class="form-label fw-bold">Tanggal Lahir</label>
            <input type="date" name="tanggal_lahir" id="tanggal_lahir" class="form-control" value="<?= esc($pegawai['tanggal_lahir']) ?>" required>
        </div>

        <!-- Gender -->
        <div class="mb-3">
            <label for="jenis_kelamin" class="form-label fw-bold">Gender</label>
            <select name="jenis_kelamin" id="jenis_kelamin" class="form-select" required>
                <option value="">-- Pilih Gender --</option>
                <option value="laki-laki" <?= ($pegawai['jenis_kelamin'] == 'laki-laki') ? 'selected' : '' ?>>Laki-laki</option>
                <option value="perempuan" <?= ($pegawai['jenis_kelamin'] == 'perempuan') ? 'selected' : '' ?>>Perempuan</option>
            </select>
        </div>

        <!-- Divisi -->
        <div class="mb-3">
            <label for="divisi" class="form-label fw-bold">Divisi</label>
            <select name="divisi" id="divisi" class="form-select" required>
                <option value="">-- Pilih Divisi --</option>
                <?php foreach($divisi as $d): ?>
                    <option value="<?= esc($d['nama_divisi']) ?>" <?= ($pegawai['divisi'] == $d['nama_divisi']) ? 'selected' : '' ?>>
                        <?= esc($d['nama_divisi']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Foto Pegawai -->
        <div class="mb-3">
            <label for="foto_pegawai" class="form-label fw-bold">Foto Pegawai</label>
            <input type="file" name="foto_pegawai" id="foto_pegawai" class="form-control">
            <?php if($pegawai['foto_pegawai']): ?>
                <img src="<?= base_url('uploads/pegawai/'.$pegawai['foto_pegawai']) ?>" class="mt-2" style="width:80px; border-radius:8px;">
            <?php endif; ?>
        </div>

        <!-- Tombol Submit -->
        <button type="submit" class="btn" style="
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            font-weight: 600;
            border-radius: 10px;
            padding: 10px 20px;
            transition: 0.3s;
        " 
        onmouseover="this.style.opacity='0.85'" 
        onmouseout="this.style.opacity='1'">
            <i class="bi bi-check2-circle me-1"></i> Update Pegawai
        </button>

    </form>
</div>

<?= $this->endSection() ?>
