<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="container-fluid">

    <!-- HEADER -->
    <div class="card p-4 shadow mb-4" style="border-radius: 15px; border: none;">
        <div style="
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 1.3rem;
            border-radius: 12px;
            color: white;
            font-weight: 700;
            font-size: 1.3rem;
            display: flex;
            align-items: center;
            gap: 10px;
        ">
            <i class="bi bi-gear-fill" style="font-size: 1.7rem;"></i>
            <span>Admin Settings</span>
        </div>

        <p class="mt-3" style="color:#4a5568; font-size:0.95rem;">
            Kelola pengaturan sistem dan preferensi admin.
        </p>
    </div>

    <!-- SETTINGS CARDS -->
    <div class="row g-4">

        <!-- Account Settings -->
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-sm p-3" style="border-radius:15px; transition:0.3s;">
                <div class="d-flex align-items-center gap-3">
                    <i class="bi bi-person-circle fs-1 text-primary"></i>
                    <div>
                        <h5 class="fw-bold mb-1">Account</h5>
                        <p class="mb-0 text-muted" style="font-size:0.9rem;">Ubah username, password, dan info akun.</p>
                    </div>
                </div>
                <a href="<?= base_url('admin/setting/account') ?>" class="btn mt-3 w-100" style="
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    font-weight:600;
                    border-radius:10px;
                    border:none;
                    transition:0.3s;
                " onmouseover="this.style.opacity='0.85'" onmouseout="this.style.opacity='1'">
                    Manage Account
                </a>
            </div>
        </div>

        <!-- System Preferences -->
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-sm p-3" style="border-radius:15px; transition:0.3s;">
                <div class="d-flex align-items-center gap-3">
                    <i class="bi bi-sliders fs-1 text-success"></i>
                    <div>
                        <h5 class="fw-bold mb-1">System</h5>
                        <p class="mb-0 text-muted" style="font-size:0.9rem;">Konfigurasi preferensi sistem dan notifikasi.</p>
                    </div>
                </div>
                <a href="<?= base_url('admin/setting/system') ?>" class="btn mt-3 w-100" style="
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    font-weight:600;
                    border-radius:10px;
                    border:none;
                    transition:0.3s;
                " onmouseover="this.style.opacity='0.85'" onmouseout="this.style.opacity='1'">
                    System Preferences
                </a>
            </div>
        </div>

        <!-- Notifications -->
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-sm p-3" style="border-radius:15px; transition:0.3s;">
                <div class="d-flex align-items-center gap-3">
                    <i class="bi bi-bell fs-1 text-warning"></i>
                    <div>
                        <h5 class="fw-bold mb-1">Notifications</h5>
                        <p class="mb-0 text-muted" style="font-size:0.9rem;">Atur jenis notifikasi yang diterima admin.</p>
                    </div>
                </div>
                <a href="<?= base_url('admin/setting/notifications') ?>" class="btn mt-3 w-100" style="
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    font-weight:600;
                    border-radius:10px;
                    border:none;
                    transition:0.3s;
                " onmouseover="this.style.opacity='0.85'" onmouseout="this.style.opacity='1'">
                    Manage Notifications
                </a>
            </div>
        </div>

    </div>
</div>

<?= $this->endSection() ?>
