<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="card p-4 shadow mb-4" style="border-radius: 15px; border: none;">

    <!-- HEADER CARD (warna samain admin) -->
    <div style="
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 1.3rem;
        border-radius: 12px;
        color: white;
        font-weight: 700;
        font-size: 1.3rem;
        display: flex;
        align-items: center;
        gap: 10px;
    ">
        <i class="bi bi-people-fill" style="font-size: 1.7rem;"></i>
        <span>Manajemen Pegawai</span>
    </div>

    <p class="mt-3" style="color:#4a5568; font-size:0.95rem;">
        <b>Kelola daftar pegawai marketing.<b>
    </p>

    <!-- TOMBOL MATCH TEMA ADMIN -->
    <a href="/admin/pegawai" 
       class="btn mt-2"
       style="
           background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
           border: none;
           padding: 10px 18px;
           color: white;
           font-weight: 600;
           border-radius: 10px;
           transition: 0.3s;
       "
       onmouseover="this.style.opacity='0.85'"
       onmouseout="this.style.opacity='1'"
    >
        <i class="bi bi-people me-2"></i>Kelola Pegawai
    </a>

</div>



<style>
    .news-table-container {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.08);
        overflow: hidden;
        animation: fadeIn 0.6s ease-out;
    }

    .table-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 1.5rem;
        margin: 0;
    }

    .table-header h3 {
        margin: 0;
        font-weight: 700;
        font-size: 1.5rem;
    }

    .table {
        margin: 0;
    }

    .table thead {
        background-color: #f8f9fa;
    }

    .table thead th {
        border: none;
        padding: 1rem;
        font-weight: 700;
        color: #2d3748;
        text-transform: uppercase;
        font-size: 0.85rem;
        letter-spacing: 0.5px;
    }

    .table tbody tr {
        transition: all 0.3s ease;
        border-bottom: 1px solid #e2e8f0;
    }

    .table tbody tr:hover {
        background-color: #f8f9fa;
        transform: scale(1.01);
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .table tbody td {
        padding: 1.25rem 1rem;
        vertical-align: middle;
        border: none;
    }

    .news-title {
        font-weight: 600;
        color: #2d3748;
        font-size: 1rem;
        margin-bottom: 0.25rem;
    }

    .news-date {
        color: #718096;
        font-size: 0.85rem;
    }

    .status-badge {
        display: inline-block;
        padding: 0.4rem 0.9rem;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .status-published {
        background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
        color: white;
    }

    .status-draft {
        background: #e2e8f0;
        color: #718096;
    }

    .btn-action {
        padding: 0.5rem 1rem;
        border-radius: 8px;
        font-size: 0.85rem;
        font-weight: 600;
        margin: 0 0.25rem;
        transition: all 0.3s ease;
        border: 2px solid;
        text-decoration: none;
        display: inline-block;
    }

    .btn-preview {
        background: white;
        color: #667eea;
        border-color: #667eea;
    }

    .btn-preview:hover {
        background: #667eea;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 10px rgba(102, 126, 234, 0.3);
    }

    .btn-edit {
        background: white;
        color: #f6ad55;
        border-color: #f6ad55;
    }

    .btn-edit:hover {
        background: #f6ad55;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 10px rgba(246, 173, 85, 0.3);
    }

    .btn-delete {
        background: white;
        color: #fc8181;
        border-color: #fc8181;
    }

    .btn-delete:hover {
        background: #fc8181;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 10px rgba(252, 129, 129, 0.3);
    }

    .modal-content {
        border-radius: 15px;
        border: none;
        box-shadow: 0 10px 40px rgba(0,0,0,0.2);
    }

    .modal-header {
        border-bottom: 2px solid #e2e8f0;
        padding: 1.5rem;
    }

    .modal-body {
        padding: 2rem;
    }

    .modal-body h2 {
        color: #2d3748;
        font-weight: 700;
        margin-bottom: 1rem;
    }

    .modal-body p {
        color: #718096;
        margin: 0;
    }

    .modal-footer {
        border-top: 2px solid #e2e8f0;
        padding: 1.5rem;
    }

    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        color: #718096;
    }

    .empty-state i {
        font-size: 4rem;
        margin-bottom: 1rem;
        opacity: 0.5;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<div class="news-table-container">
    <div class="table-header">
        <h3><i class="bi bi-newspaper me-2"></i>Daftar Berita</h3>
    </div>
    
    <?php if(empty($newses)): ?>
        <div class="empty-state">
            <i class="bi bi-inbox"></i>
            <h4>Belum ada berita</h4>
            <p>Mulai dengan membuat berita baru</p>
            <a href="<?= base_url('admin/news/new') ?>" class="btn btn-primary mt-3">
                <i class="bi bi-plus-circle me-2"></i>Buat Berita Baru
            </a>
        </div>
    <?php else: ?>
        <table class="table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Title</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($newses as $news): ?>
                <tr>
                    <td><strong><?= $news['id'] ?></strong></td>
                    <td>
                        <div class="news-title"><?= esc($news['title']) ?></div>
                        <div class="news-date">
                            <i class="bi bi-calendar3 me-1"></i><?= date('d M Y H:i', strtotime($news['created_at'])) ?>
                        </div>
                    </td>
                    <td>
                        <?php if($news['status'] === 'published'): ?>
                            <span class="status-badge status-published">
                                <i class="bi bi-check-circle me-1"></i><?= $news['status'] ?>
                            </span>
                        <?php else: ?>
                            <span class="status-badge status-draft">
                                <i class="bi bi-file-earmark me-1"></i><?= $news['status'] ?>
                            </span>
                        <?php endif ?>
                    </td>
                    <td>
                        <a href="<?= base_url('admin/news/'.$news['id'].'/preview') ?>" 
                           class="btn-action btn-preview" 
                           target="_blank"
                           title="Preview">
                            <i class="bi bi-eye me-1"></i>Preview
                        </a>
                        <a href="<?= base_url('admin/news/'.$news['id'].'/edit') ?>" 
                           class="btn-action btn-edit"
                           title="Edit">
                            <i class="bi bi-pencil me-1"></i>Edit
                        </a>
                        <a href="#" 
                           data-href="<?= base_url('admin/news/'.$news['id'].'/delete') ?>" 
                           onclick="confirmToDelete(this)" 
                           class="btn-action btn-delete"
                           title="Delete">
                            <i class="bi bi-trash me-1"></i>Delete
                        </a>
                    </td>
                </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    <?php endif ?>
</div>

<!-- Modal Konfirmasi Delete -->
<div id="confirm-dialog" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-exclamation-triangle-fill text-warning me-2"></i>Konfirmasi Hapus
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <h2>Apakah Anda yakin?</h2>
                <p>Data yang dihapus tidak dapat dikembalikan. Tindakan ini bersifat permanen.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="bi bi-x-circle me-1"></i>Batal
                </button>
                <a href="#" role="button" id="delete-button" class="btn btn-danger">
                    <i class="bi bi-trash me-1"></i>Hapus
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function confirmToDelete(el){
    // Set href di tombol delete
    $("#delete-button").attr("href", el.dataset.href);
    // Tampilkan modal
    $("#confirm-dialog").modal('show');
}
</script>

<?= $this->endSection() ?>