<?= $this->extend('layout/post_layout') ?>
<?= $this->section('content') ?>

<style>
    .news-card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.08);
        transition: .3s ease;
    }
    .news-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 6px 16px rgba(0,0,0,0.12);
    }
    .news-title a {
        font-weight: 700;
        color: #333;
        text-decoration: none;
        transition: .2s ease;
    }
    .news-title a:hover {
        color: #667eea;
    }
    .news-content {
        color: #666;
        font-size: .95rem;
    }
</style>

<div class="container py-4">

    <?php foreach ($newses as $news) : ?>

        <div class="card news-card mb-4">
            <div class="card-body">

                <h5 class="news-title">
                    <a href="/news/<?= $news['slug'] ?>">
                        <?= esc($news['title']) ?>
                    </a>
                </h5>

                <p class="news-content">
                    <?= esc(substr($news['content'], 0, 120)) ?>...
                </p>

                <a href="/news/<?= $news['slug'] ?>" class="btn btn-primary btn-sm">
                    Read More
                </a>

            </div>
        </div>

    <?php endforeach; ?>

</div>

<?= $this->endSection() ?>
