<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Pegawai Marketing</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body { background: #eef3fa; font-family: 'Segoe UI', sans-serif; }

        /* HEADER NUANSA ADMIN */
        .header-box {
            background: linear-gradient(90deg, #6a5af9, #8369ff);
            padding: 22px;
            border-radius: 18px;
            margin-top: 20px;
            margin-bottom: 30px;
            text-align: center;
        }
        .header-box h1 {
            color: white;
            font-weight: 800;
            margin: 0;
        }

        /* CARD PEGAWAI */
        .pegawai-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            overflow: hidden;
            transition: 0.2s;
        }
        .pegawai-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 18px rgba(0,0,0,0.12);
        }

        .pegawai-card img {
            width: 100%;
            height: 320px;
            object-fit: cover;
            background: #ddd;
        }

        .pegawai-info {
            padding: 18px;
        }

        .pegawai-info h4 {
            font-weight: 700;
        }

        .label { font-weight: 700; }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            .pegawai-card img { height: 260px; }
        }
        @media (max-width: 576px) {
            .pegawai-card img { height: 230px; }
        }
    </style>
</head>

<body>

<div class="container">

    <!-- HEADER UNGU ALA ADMIN -->
    <div class="header-box">
        <h1>Daftar Pegawai Marketing</h1>
    </div>

    <div class="row g-4">

        <?php foreach ($pegawai as $row): ?>
        <div class="col-lg-3 col-md-4 col-sm-6">
            <div class="pegawai-card">

                <!-- FOTO -->
                <img src="<?= base_url('uploads/pegawai/'.$row['foto_pegawai']) ?>" 
                     alt="Foto Pegawai">

                <!-- DETAIL -->
                <div class="pegawai-info">
                    <h4><?= esc($row['nama_pegawai']) ?></h4>

                    <p><span class="label">Divisi:</span> Marketing</p>
                    <p><span class="label">Tgl Lahir:</span> <?= $row['tanggal_lahir'] ?></p>
                    <p><span class="label">Gender:</span> <?= $row['jenis_kelamin'] ?></p>
                </div>

            </div>
        </div>
        <?php endforeach; ?>

    </div>

</div>

</body>
</html>
