<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');
$routes->get('/activities', 'Home::activities');
$routes->get('/biodata', 'Home::biodata');
$routes->get('/education', 'Home::education');

// Auth Routes
$routes->get('/login', 'AuthController::login');
$routes->post('/login/auth', 'AuthController::auth');
$routes->get('/logout', 'AuthController::logout');

$routes->group('admin', ['namespace' => 'App\Controllers\Admin'], function($routes){
    $routes->get('/', 'Dashboard::index'); // Dashboard

    // Activities
    $routes->get('activities', 'Activities::index');
    $routes->get('activities/create', 'Activities::create');
    $routes->post('activities/store', 'Activities::store');
    $routes->get('activities/edit/(:num)', 'Activities::edit/$1');
    $routes->post('activities/update/(:num)', 'Activities::update/$1');
    $routes->get('activities/delete/(:num)', 'Activities::delete/$1');

    // Biodata
    $routes->get('biodata', 'Biodata::index');
    $routes->get('biodata/create', 'Biodata::create');
    $routes->post('biodata/store', 'Biodata::store');
    $routes->get('biodata/edit/(:num)', 'Biodata::edit/$1');
    $routes->post('biodata/update/(:num)', 'Biodata::update/$1');
    $routes->get('biodata/delete/(:num)', 'Biodata::delete/$1');

    // Education
    $routes->get('education', 'Education::index');
    $routes->get('education/create', 'Education::create');
    $routes->post('education/store', 'Education::store');
    $routes->get('education/edit/(:num)', 'Education::edit/$1');
    $routes->post('education/update/(:num)', 'Education::update/$1');
    $routes->get('education/delete/(:num)', 'Education::delete/$1');
});

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */