<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - Naisyela</title>
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Outfit', 'sans-serif'],
                    },
                    colors: {
                        brown: {
                            50: '#efebe9',
                            100: '#d7ccc8',
                            200: '#bcaaa4',
                            300: '#a1887f',
                            400: '#8d6e63',
                            500: '#795548',
                            600: '#6d4c41',
                            700: '#5d4037',
                            800: '#4e342e',
                            900: '#3e2723',
                        }
                    }
                }
            }
        }
    </script>
    <script src="https://unpkg.com/lucide@latest"></script>
</head>
<body class="bg-brown-50 font-sans min-h-screen flex items-center justify-center p-4">



    <div class="w-full max-w-md bg-white rounded-2xl shadow-xl overflow-hidden animate-fade-in-up">
        
        <!-- Header -->
        <div class="bg-gradient-to-r from-brown-500 to-brown-600 p-8 text-center text-white">
            <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-white/20 backdrop-blur-sm mb-4">
                <i data-lucide="lock" class="w-8 h-8 text-white"></i>
            </div>
            <h1 class="text-2xl font-bold">Selamat Datang</h1>
            <p class="text-brown-100 mt-2">Silakan login untuk masuk ke panel admin</p>
        </div>

        <!-- Form -->
        <div class="p-8">
            <form action="<?= base_url('login/auth') ?>" method="post" class="space-y-6">
                
                <div>
                    <label for="username" class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <i data-lucide="user" class="h-5 w-5 text-gray-400"></i>
                        </div>
                        <input type="text" name="username" id="username" required 
                            class="block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-brown-500 focus:border-brown-500 transition-colors"
                            placeholder="Masukkan username anda">
                    </div>
                </div>

                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <i data-lucide="key" class="h-5 w-5 text-gray-400"></i>
                        </div>
                        <input type="password" name="password" id="password" required 
                            class="block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-brown-500 focus:border-brown-500 transition-colors"
                            placeholder="Masukkan password anda">
                    </div>
                </div>

                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input id="remember-me" name="remember-me" type="checkbox" class="h-4 w-4 text-brown-600 focus:ring-brown-500 border-gray-300 rounded">
                        <label for="remember-me" class="ml-2 block text-sm text-gray-600">Ingat saya</label>
                    </div>
                    <div class="text-sm">
                        <a href="#" class="font-medium text-brown-600 hover:text-brown-500">Lupa password?</a>
                    </div>
                </div>

                <button type="submit" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-brown-600 hover:bg-brown-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brown-500 transition-all transform hover:scale-[1.02]">
                    Masuk Sekarang
                </button>

                <div class="text-center mt-6 border-t border-gray-100 pt-4">
                    <a href="<?= base_url('/') ?>" class="inline-flex items-center text-sm text-gray-500 hover:text-brown-600 transition group">
                        <i data-lucide="arrow-left" class="w-4 h-4 mr-2 group-hover:-translate-x-1 transition-transform"></i>
                        Kembali ke Halaman Depan
                    </a>
                </div>
            </form>
        </div>
        
        <!-- Footer -->
        <div class="bg-gray-50 px-8 py-4 border-t border-gray-100 flex items-center justify-center">
            <p class="text-xs text-gray-500">
                &copy; <?= date('Y') ?> Naisyela Admin Panel. All rights reserved.
            </p>
        </div>

    </div>

    <script>
        lucide.createIcons();
    </script>
</body>
</html>
