<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="mb-6 flex justify-between items-center">
    <h1 class="text-3xl font-bold text-gray-800">Aktivitas Harian</h1>
    <a href="<?= base_url('admin/activities/create') ?>" class="bg-brown-600 hover:bg-brown-700 text-white px-4 py-2 rounded-lg flex items-center shadow-md transition">
        <i data-lucide="plus" class="w-4 h-4 mr-2"></i> Tambah Baru
    </a>
</div>

<!-- Search & Flter -->
<div class="mb-6 bg-white p-4 rounded-lg shadow-sm border border-brown-50">
    <form action="" method="get" class="flex gap-4">
        <input type="text" name="keyword" value="<?= esc($keyword) ?>" placeholder="Cari aktivitas..." class="flex-1 border-gray-300 border rounded-lg px-4 py-2 focus:ring-brown-500 focus:border-brown-500 outline-none">
        
        <select name="sort" class="border-gray-300 border rounded-lg px-4 py-2 focus:ring-brown-500 outline-none">
            <option value="id" <?= $sort == 'id' ? 'selected' : '' ?>>ID</option>
            <option value="date" <?= $sort == 'date' ? 'selected' : '' ?>>Tanggal</option>
            <option value="activity_name" <?= $sort == 'activity_name' ? 'selected' : '' ?>>Nama</option>
        </select>
        
        <select name="order" class="border-gray-300 border rounded-lg px-4 py-2 focus:ring-brown-500 outline-none">
            <option value="asc" <?= $order == 'asc' ? 'selected' : '' ?>>Terlama</option>
            <option value="desc" <?= $order == 'desc' ? 'selected' : '' ?>>Terbaru</option>
        </select>

        <button type="submit" class="bg-brown-100 text-brown-700 hover:bg-brown-200 px-6 py-2 rounded-lg font-medium transition">
            Filter
        </button>
    </form>
</div>

<!-- Table -->
<div class="bg-white rounded-xl shadow-md overflow-hidden border border-gray-100">
    <table class="w-full text-left">
        <thead class="bg-brown-50 text-brown-800 font-semibold uppercase text-sm border-b border-brown-100">
            <tr>
                <th class="px-6 py-4">ID</th>
                <th class="px-6 py-4">Foto</th>
                <th class="px-6 py-4">Tanggal</th>
                <th class="px-6 py-4">Nama Aktivitas</th>
                <th class="px-6 py-4 text-right">Aksi</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            <?php foreach ($activities as $index => $item): ?>
            <tr class="hover:bg-brown-50/50 transition duration-150">
                <td class="px-6 py-4 text-gray-600">#<?= $index + 1 + (4 * ($pager->getCurrentPage() - 1)) ?></td>
                <td class="px-6 py-4">
                    <?php if (!empty($item['media'])): ?>
                        <img src="<?= base_url('uploads/activities/' . $item['media']) ?>" alt="Foto" class="w-12 h-12 rounded-lg object-cover border border-gray-200">
                    <?php else: ?>
                        <div class="w-12 h-12 rounded-lg bg-brown-100 flex items-center justify-center text-brown-500">
                            <i data-lucide="image" class="w-6 h-6"></i>
                        </div>
                    <?php endif; ?>
                </td>
                <td class="px-6 py-4">
                    <div class="font-medium text-gray-900"><?= $item['date'] ?></div>
                </td>
                <td class="px-6 py-4 text-gray-800"><?= esc($item['activity_name']) ?></td>
                <td class="px-6 py-4 text-right">
                    <a href="<?= base_url('admin/activities/edit/' . $item['id']) ?>" class="text-brown-600 hover:text-brown-800 mr-3 font-medium text-sm">Edit</a>
                    <a href="<?= base_url('admin/activities/delete/' . $item['id']) ?>" onclick="return confirm('Apakah Anda yakin?')" class="text-red-500 hover:text-red-700 font-medium text-sm">Hapus</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    
    <!-- Pagination -->
    <!-- Pagination removed as requested -->
</div>

<?= $this->endSection() ?>
