<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto">
    <div class="mb-6 flex items-center justify-between">
        <h1 class="text-3xl font-bold text-gray-800">Edit Biodata</h1>
        <a href="<?= base_url('admin/biodata') ?>" class="text-gray-500 hover:text-gray-700">Kembali ke Daftar</a>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-brown-50">
        <?php if (session()->has('errors')): ?>
            <div class="bg-red-50 text-red-600 p-4 rounded-lg mb-6 text-sm">
                <ul>
                <?php foreach (session('errors') as $error): ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach ?>
                </ul>
            </div>
        <?php endif ?>

        <form action="<?= base_url('admin/biodata/update/' . $biodata['id']) ?>" method="post" enctype="multipart/form-data">
            <input type="hidden" name="old_photo" value="<?= $biodata['photo'] ?>">
            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Nama Lengkap</label>
                <input type="text" name="name" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('name', $biodata['name']) ?>">
            </div>

            <div class="grid grid-cols-2 gap-6 mb-6">
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Email</label>
                    <input type="email" name="email" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('email', $biodata['email']) ?>">
                </div>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Telepon</label>
                    <input type="text" name="phone" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('phone', $biodata['phone']) ?>">
                </div>
            </div>

            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Alamat</label>
                <textarea name="address" rows="3" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition"><?= old('address', $biodata['address']) ?></textarea>
            </div>

            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Ringkasan / Tentang</label>
                <textarea name="summary" rows="4" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition"><?= old('summary', $biodata['summary']) ?></textarea>
            </div>

            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Foto Profil</label>
                <?php if (!empty($biodata['photo'])): ?>
                    <div class="mb-3">
                        <img src="<?= base_url('uploads/biodata/' . $biodata['photo']) ?>" alt="Foto Saat Ini" class="h-40 w-40 object-cover rounded-full border border-gray-200">
                    </div>
                <?php endif; ?>
                <input type="file" name="photo" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-brown-50 file:text-brown-700 hover:file:bg-brown-100">
            </div>

            <button type="submit" class="w-full bg-brown-600 hover:bg-brown-700 text-white font-bold py-3 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-0.5">
                Perbarui Biodata
            </button>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
