<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="mb-8">
    <h1 class="text-3xl font-bold text-gray-800">Dashboard</h1>
    <p class="text-gray-500">Selamat datang di Panel Admin CI4 Naisyela.</p>
</div>

<div class="grid grid-cols-1 md:grid-cols-3 gap-6">
    <!-- Activities Card -->
    <a href="<?= base_url('admin/activities') ?>" class="block transform transition hover:scale-105">
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-brown-500 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm font-medium uppercase tracking-wider">Aktivitas</p>
                <p class="text-3xl font-bold text-gray-800"><?= $activity_count ?></p>
            </div>
            <div class="p-3 bg-brown-100 rounded-full text-brown-600">
                <i data-lucide="calendar" class="w-8 h-8"></i>
            </div>
        </div>
    </a>

    <!-- Biodata Card -->
    <a href="<?= base_url('admin/biodata') ?>" class="block transform transition hover:scale-105">
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-brown-500 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm font-medium uppercase tracking-wider">Profil Biodata</p>
                <p class="text-3xl font-bold text-gray-800"><?= $biodata_count ?></p>
            </div>
            <div class="p-3 bg-brown-100 rounded-full text-brown-600">
                <i data-lucide="user" class="w-8 h-8"></i>
            </div>
        </div>
    </a>

    <!-- Education Card -->
    <a href="<?= base_url('admin/education') ?>" class="block transform transition hover:scale-105">
        <div class="bg-white p-6 rounded-xl shadow-md border-l-4 border-brown-500 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm font-medium uppercase tracking-wider">Data Pendidikan</p>
                <p class="text-3xl font-bold text-gray-800"><?= $education_count ?></p>
            </div>
            <div class="p-3 bg-brown-100 rounded-full text-brown-600">
                <i data-lucide="graduation-cap" class="w-8 h-8"></i>
            </div>
        </div>
    </a>
</div>

<div class="mt-12">
    <div class="bg-brown-100 rounded-xl p-8 text-center">
        <i data-lucide="heart" class="w-12 h-12 text-brown-600 mx-auto mb-4"></i>
        <h2 class="text-2xl font-bold text-brown-800 mb-2">Selamat Datang Kembali!</h2>
        <p class="text-brown-600 max-w-lg mx-auto">Gunakan sidebar untuk mengelola aktivitas, biodata, dan riwayat pendidikan Anda. Perubahan di sini akan segera terlihat di website utama.</p>
    </div>
</div>

<?= $this->endSection() ?>
