<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<div class="text-center mb-12">
    <h1 class="text-4xl font-bold text-gray-800 mb-4">Riwayat Pendidikan</h1>
    <p class="text-gray-600">Perjalanan akademis dan pencapaian.</p>
</div>

<div class="max-w-4xl mx-auto mb-12">
    <form action="" method="get" class="bg-white p-4 rounded-xl shadow-sm border border-brown-50 flex flex-col md:flex-row gap-4">
        <div class="flex-1 relative">
            <i data-lucide="search" class="absolute left-3 top-3 text-gray-400 w-5 h-5"></i>
            <input type="text" name="keyword" value="<?= esc($keyword) ?>" placeholder="Cari sekolah..." class="w-full pl-10 border-gray-200 border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brown-400 focus:border-transparent outline-none">
        </div>
         <select name="sort" class="border-gray-200 border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brown-400 outline-none bg-white">
            <option value="end_year" <?= $sort == 'end_year' ? 'selected' : '' ?>>Tahun</option>
            <option value="level" <?= $sort == 'level' ? 'selected' : '' ?>>Jenjang</option>
        </select>
        <button type="submit" class="bg-brown-500 text-white px-8 py-2 rounded-lg font-medium hover:bg-brown-600 transition">
            Filter
        </button>
    </form>
</div>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
    <?php foreach ($education as $index => $item): ?>
    <div class="group relative bg-white rounded-[2.5rem] p-8 shadow-xl shadow-brown-100/50 hover:shadow-2xl hover:shadow-brown-200/50 transition-all duration-500 hover:-translate-y-2 overflow-hidden border border-brown-50 animate-fade-in-up" style="animation-delay: <?= $index * 0.1 ?>s;">
         <!-- Decorative Background Blobs -->
        <div class="absolute top-0 right-0 w-40 h-40 bg-gradient-to-br from-brown-100 to-cream-50 rounded-bl-[100%] -mr-10 -mt-10 transition-transform duration-700 group-hover:scale-110 opacity-60"></div>
        <div class="absolute bottom-0 left-0 w-32 h-32 bg-gradient-to-tr from-cream-50 to-brown-50 rounded-tr-[100%] -ml-8 -mb-8 transition-transform duration-700 group-hover:scale-110 opacity-60"></div>
        
        <!-- Content Container -->
        <div class="relative z-10 flex flex-col h-full">
            <!-- Header: Icon & Badge -->
            <div class="flex justify-between items-start mb-6">
                <div class="w-16 h-16 rounded-2xl bg-gradient-to-br from-white to-brown-50 shadow-inner border border-white flex items-center justify-center text-brown-500 group-hover:rotate-12 transition-transform duration-500">
                    <?php if (strpos(strtolower($item['level']), 'kuliah') !== false): ?>
                         <i data-lucide="graduation-cap" class="w-8 h-8"></i>
                    <?php elseif (strpos(strtolower($item['level']), 'smk') !== false): ?>
                         <i data-lucide="briefcase" class="w-8 h-8"></i>
                    <?php elseif (strpos(strtolower($item['level']), 'smp') !== false): ?>
                         <i data-lucide="book-open" class="w-8 h-8"></i>
                    <?php else: ?>
                         <i data-lucide="pencil" class="w-8 h-8"></i>
                    <?php endif; ?>
                </div>
                
                <div class="flex flex-col items-end">
                    <span class="px-4 py-1 bg-brown-500 text-white text-xs font-bold uppercase tracking-widest rounded-full shadow-lg shadow-brown-200 group-hover:bg-brown-600 transition-colors">
                        <?= esc($item['level']) ?>
                    </span>

                </div>
            </div>

            <!-- Main Text -->
            <div class="mb-6">
                <h3 class="text-2xl font-black text-gray-800 leading-tight mb-2 group-hover:text-brown-600 transition-colors">
                    <?= esc($item['school_name']) ?>
                </h3>
            </div>

            <!-- Footer -->
            <div class="mt-auto pt-4 flex items-center justify-between text-sm text-gray-500">
                <div class="flex items-center px-3 py-1.5 bg-brown-50/50 rounded-lg border border-brown-100/50">
                    <i data-lucide="calendar-range" class="w-4 h-4 mr-2 text-brown-400"></i>
                    <span class="font-semibold text-gray-600"><?= esc($item['start_year']) ?> - <?= esc($item['end_year']) ?></span>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>



<?= $this->endSection() ?>
