<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<!-- Hero Section -->
<section class="relative py-20 mb-16 overflow-hidden rounded-[3rem] shadow-[0_20px_50px_-12px_rgba(121,85,72,0.3)] bg-gradient-to-br from-brown-400 via-brown-500 to-cream-500">
    <!-- Abstract Background Shapes -->
    <div class="absolute top-0 left-0 w-full h-full overflow-hidden z-0 pointer-events-none">
        <div class="absolute top-[-10%] left-[-10%] w-[40rem] h-[40rem] bg-white rounded-full mix-blend-overlay filter blur-3xl opacity-20 animate-blob"></div>
        <div class="absolute bottom-[-10%] right-[-10%] w-[35rem] h-[35rem] bg-cream-200 rounded-full mix-blend-overlay filter blur-3xl opacity-30 animate-blob animation-delay-2000"></div>
        <!-- Texture overlay -->
        <div class="absolute inset-0 bg-[url('https://grainy-gradients.vercel.app/noise.svg')] opacity-20 brightness-100 contrast-150"></div>
    </div>

    <div class="relative z-10 max-w-5xl mx-auto px-6 text-center text-white">
        <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-white/10 backdrop-blur-md border border-white/20 font-medium text-xs mb-6 animate-fade-in-up hover:bg-white/20 transition cursor-default">
            <span class="w-1.5 h-1.5 rounded-full bg-cream-300 animate-pulse"></span> Selamat Datang di Website Pribadi Saya
        </div>
        
        <h1 class="text-4xl md:text-6xl font-black mb-6 tracking-tight leading-tight animate-fade-in-up drop-shadow-md font-sans">
            Halo, Saya <br>
            <span class="text-transparent bg-clip-text bg-gradient-to-b from-white to-brown-100 filter drop-shadow">Naisyela</span>
        </h1>
        

        
        <div class="flex flex-col sm:flex-row justify-center gap-5 animate-fade-in-up px-4 pb-4" style="animation-delay: 0.4s;">
            <a href="<?= base_url('biodata') ?>" class="group bg-white text-brown-600 px-8 py-3 rounded-full font-bold text-base hover:bg-brown-50 transition-all duration-300 shadow-xl hover:shadow-white/20 hover:-translate-y-1 flex items-center justify-center">
                <i data-lucide="user" class="w-4 h-4 mr-2 group-hover:rotate-12 transition duration-300"></i> Lihat Biodata
            </a>
            <a href="<?= base_url('activities') ?>" class="group bg-brown-600/30 backdrop-blur-md border border-white/30 text-white px-8 py-3 rounded-full font-bold text-base hover:bg-white/20 transition-all duration-300 shadow-lg hover:shadow-xl flex items-center justify-center">
                <i data-lucide="sparkles" class="w-4 h-4 mr-2 group-hover:scale-110 transition duration-300"></i> Aktivitas Terbaru
            </a>
        </div>
    </div>
</section>

<!-- Features Grid -->
<div class="grid md:grid-cols-3 gap-8 mb-24 px-4 -mt-10 relative z-20">
    <a href="<?= base_url('activities') ?>" class="block h-full group">
        <div class="bg-white/70 backdrop-blur-xl p-6 rounded-[2rem] shadow-[0_8px_30px_rgb(0,0,0,0.04)] hover:shadow-[0_20px_40px_-5px_rgba(121,85,72,0.2)] hover:-translate-y-2 transition-all duration-300 border border-white h-full flex flex-col">
            <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-brown-100 to-cream-100 flex items-center justify-center text-brown-600 mb-4 group-hover:scale-110 transition duration-300 shadow-inner">
                <i data-lucide="calendar" class="w-7 h-7"></i>
            </div>
            <h3 class="text-xl font-bold text-gray-800 mb-2 group-hover:text-brown-600 transition">Aktivitas Harian</h3>
            <p class="text-gray-500 mb-4 text-sm leading-relaxed flex-grow">Jurnal digital kegiatan sehari-hari saya yang penuh warna dan inspirasi.</p>
            <div class="text-brown-500 text-sm font-bold group-hover:text-brown-700 inline-flex items-center">
                Jelajahi <i data-lucide="arrow-right" class="w-4 h-4 ml-2 group-hover:translate-x-2 transition"></i>
            </div>
        </div>
    </a>

    <a href="<?= base_url('biodata') ?>" class="block h-full group">
        <div class="bg-white/70 backdrop-blur-xl p-6 rounded-[2rem] shadow-[0_8px_30px_rgb(0,0,0,0.04)] hover:shadow-[0_20px_40px_-5px_rgba(121,85,72,0.2)] hover:-translate-y-2 transition-all duration-300 border border-white h-full flex flex-col">
            <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-brown-100 to-cream-100 flex items-center justify-center text-brown-600 mb-4 group-hover:scale-110 transition duration-300 shadow-inner">
                <i data-lucide="user" class="w-7 h-7"></i>
            </div>
            <h3 class="text-xl font-bold text-gray-800 mb-2 group-hover:text-brown-600 transition">Biodata & Profil</h3>
            <p class="text-gray-500 mb-4 text-sm leading-relaxed flex-grow">Mengenal lebih dekat siapa saya, keahlian, dan apa yang saya kerjakan.</p>
            <div class="text-brown-500 text-sm font-bold group-hover:text-brown-700 inline-flex items-center">
                Lihat Profil <i data-lucide="arrow-right" class="w-4 h-4 ml-2 group-hover:translate-x-2 transition"></i>
            </div>
        </div>
    </a>

    <a href="<?= base_url('education') ?>" class="block h-full group">
        <div class="bg-white/70 backdrop-blur-xl p-6 rounded-[2rem] shadow-[0_8px_30px_rgb(0,0,0,0.04)] hover:shadow-[0_20px_40px_-5px_rgba(121,85,72,0.2)] hover:-translate-y-2 transition-all duration-300 border border-white h-full flex flex-col">
            <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-brown-100 to-cream-100 flex items-center justify-center text-brown-600 mb-4 group-hover:scale-110 transition duration-300 shadow-inner">
                <i data-lucide="graduation-cap" class="w-7 h-7"></i>
            </div>
            <h3 class="text-xl font-bold text-gray-800 mb-2 group-hover:text-brown-600 transition">Pendidikan</h3>
            <p class="text-gray-500 mb-4 text-sm leading-relaxed flex-grow">Riwayat perjalanan akademis yang membentuk pengetahuan saya.</p>
            <div class="text-brown-500 text-sm font-bold group-hover:text-brown-700 inline-flex items-center">
                Lihat Riwayat <i data-lucide="arrow-right" class="w-4 h-4 ml-2 group-hover:translate-x-2 transition"></i>
            </div>
        </div>
    </a>
</div>

<!-- Recent Activities Snippet -->
<?php if (!empty($recent_activities)): ?>
<section class="mb-20">
    <div class="flex items-center justify-between mb-10 px-4">
        <h2 class="text-4xl font-bold text-gray-800 tracking-tight">Pembaruan <span class="text-brown-500">Terbaru</span></h2>
        <a href="<?= base_url('activities') ?>" class="hidden md:flex items-center text-gray-500 hover:text-brown-500 transition font-medium">
            Lihat Semua <i data-lucide="arrow-right" class="w-4 h-4 ml-2"></i>
        </a>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <?php foreach ($recent_activities as $index => $activity): ?>
        <div class="bg-white rounded-3xl shadow-lg overflow-hidden hover:shadow-2xl transition duration-300 transform hover:-translate-y-1 border border-brown-100 group animate-fade-in-up" style="animation-delay: <?= $index * 0.1 ?>s;">
            <div class="h-48 bg-gradient-to-br from-brown-50 to-cream-50 flex items-center justify-center text-brown-200 relative overflow-hidden">
                <?php if ($activity['media']): ?>
                    <img src="<?= base_url('uploads/activities/' . $activity['media']) ?>" alt="Activity" class="object-cover w-full h-full group-hover:scale-105 transition duration-700">
                <?php else: ?>
                    <i data-lucide="image" class="w-16 h-16 opacity-50 group-hover:scale-110 transition duration-500"></i>
                <?php endif; ?>
                <div class="absolute top-4 left-4 bg-white/90 backdrop-blur-sm px-3 py-1 rounded-full text-xs font-bold text-brown-600 shadow-sm">
                    <?= date('M d', strtotime($activity['date'])) ?>
                </div>
            </div>
            <div class="p-6">
                <h3 class="font-bold text-lg text-gray-800 mb-2 truncate leading-snug group-hover:text-brown-600 transition"><?= esc($activity['activity_name']) ?></h3>

            </div>
        </div>
        <?php endforeach; ?>
    </div>
    
    <div class="mt-8 text-center md:hidden">
         <a href="<?= base_url('activities') ?>" class="inline-flex items-center text-brown-500 font-bold">
            Lihat Semua Pembaruan <i data-lucide="arrow-right" class="w-5 h-5 ml-2"></i>
        </a>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection() ?>
