<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Naisyela - Personal Website</title>
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Outfit', 'sans-serif'],
                    },
                    colors: {
                        brown: {
                            50: '#efebe9',
                            100: '#d7ccc8',
                            200: '#bcaaa4',
                            300: '#a1887f',
                            400: '#8d6e63',
                            500: '#795548',
                            600: '#6d4c41',
                            700: '#5d4037',
                            800: '#4e342e',
                            900: '#3e2723',
                        },
                        cream: {
                            50: '#fff8e1',
                            100: '#ffecb3',
                            200: '#ffe082',
                            300: '#ffd54f',
                            400: '#ffca28',
                            500: '#ffc107',
                        },
                        orange: { // Keep for specific accents if needed
                             50: '#fff7ed',
                             100: '#ffedd5',
                             500: '#f97316', 
                        }
                    },
                    animation: {
                        'fade-in-up': 'fadeInUp 0.8s ease-out forwards',
                        'slide-in-left': 'slideInLeft 0.8s ease-out forwards',
                        'slide-in-right': 'slideInRight 0.8s ease-out forwards',
                        'bounce-slight': 'bounceSlight 3s infinite',
                        'blob': 'blob 7s infinite',
                    },
                    keyframes: {
                        blob: {
                            '0%': { transform: 'translate(0px, 0px) scale(1)' },
                            '33%': { transform: 'translate(30px, -50px) scale(1.1)' },
                            '66%': { transform: 'translate(-20px, 20px) scale(0.9)' },
                            '100%': { transform: 'translate(0px, 0px) scale(1)' },
                        },
                        fadeInUp: {
                            '0%': { opacity: '0', transform: 'translateY(20px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' },
                        },
                        slideInLeft: {
                            '0%': { opacity: '0', transform: 'translateX(-50px)' },
                            '100%': { opacity: '1', transform: 'translateX(0)' },
                        },
                        slideInRight: {
                            '0%': { opacity: '0', transform: 'translateX(50px)' },
                            '100%': { opacity: '1', transform: 'translateX(0)' },
                        },
                        bounceSlight: {
                            '0%, 100%': { transform: 'translateY(0)' },
                            '50%': { transform: 'translateY(-10px)' },
                        }
                    }
                }
            }
        }
    </script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        .glass {
            background: rgba(255, 255, 255, 0.6);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.5);
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(12px);
            box-shadow: 0 10px 40px -10px rgba(121, 85, 72, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.6);
        }
        .text-gradient {
            background-clip: text;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-image: linear-gradient(to right, #8d6e63, #d7ccc8);
        }
    </style>
</head>
<body class="bg-brown-50 text-gray-800 font-sans min-h-screen flex flex-col selection:bg-brown-200 selection:text-brown-900">

    <!-- Header -->
    <header class="bg-white/70 backdrop-blur-lg sticky top-0 z-50 shadow-sm border-b border-brown-100">
        <div class="container mx-auto px-6 py-4 flex justify-between items-center">
            <h1 class="text-2xl font-bold text-brown-600 tracking-tight flex items-center gap-2">
                <span class="bg-brown-100 p-1.5 rounded-lg"><i data-lucide="sparkles" class="w-5 h-5"></i></span>
                Naisyela
            </h1>
            <nav class="hidden md:flex space-x-1">
                <a href="<?= base_url('/') ?>" class="px-4 py-2 rounded-full text-gray-600 hover:bg-brown-50 hover:text-brown-600 font-medium transition">Beranda</a>
                <a href="<?= base_url('activities') ?>" class="px-4 py-2 rounded-full text-gray-600 hover:bg-brown-50 hover:text-brown-600 font-medium transition">Aktivitas</a>
                <a href="<?= base_url('biodata') ?>" class="px-4 py-2 rounded-full text-gray-600 hover:bg-brown-50 hover:text-brown-600 font-medium transition">Biodata</a>
                <a href="<?= base_url('education') ?>" class="px-4 py-2 rounded-full text-gray-600 hover:bg-brown-50 hover:text-brown-600 font-medium transition">Pendidikan</a>
            </nav>
            <a href="<?= base_url('admin') ?>" class="text-sm px-6 py-2.5 rounded-full bg-brown-600 text-white hover:bg-brown-700 transition font-semibold shadow-lg shadow-brown-200">Login</a>
        </div>
    </header>

    <!-- Content -->
    <main class="flex-grow container mx-auto px-6 py-8 relative">
        <!-- Floating background blobs -->
        <div class="fixed top-20 left-10 w-96 h-96 bg-brown-200/40 rounded-full mix-blend-multiply filter blur-3xl animate-blob pointer-events-none -z-10"></div>
        <div class="fixed bottom-20 right-10 w-96 h-96 bg-cream-200/40 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-4000 pointer-events-none -z-10"></div>
        
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer class="bg-white/40 backdrop-blur border-t border-brown-100 py-12 mt-12 bg-gradient-to-b from-white to-brown-50">
        <div class="container mx-auto px-6 text-center text-gray-500">
            <div class="flex justify-center gap-6 mb-6">
                 <a href="https://instagram.com" target="_blank" class="w-12 h-12 bg-white rounded-2xl flex items-center justify-center text-brown-500 shadow-sm border border-brown-100 hover:scale-110 hover:shadow-md transition duration-300">
                     <i data-lucide="instagram" class="w-6 h-6"></i>
                 </a>
            </div>
            <p class="font-medium text-brown-800 text-lg">Terima kasih telah berkunjung di website kami</p>
        </div>
    </footer>

    <script>
        lucide.createIcons();
    </script>
</body>
</html>
