# Setup Login System

## Langkah-langkah Setup

### 1. Jalankan Migration
Jalankan migration untuk memastikan tabel `users` dan kolom pendukung social login tersedia:

```bash
php spark migrate
```

### 2. Jalankan Seeder (Opsional)
Jalankan seeder untuk membuat user admin default:

```bash
php spark db:seed UserSeeder
```

**Default Credentials:**
- Username: `admin`
- Password: `admin123`

### 3. Tambahkan Background & Logo
- Letakkan logo Universitas Yatsi Madani dengan nama `logo-uym.png` di folder:
```
public/images/logo-uym.png
```
- Ganti gambar latar dengan file `login-mountain.jpg` (gambar gunung pilihan Anda) di folder yang sama:
```
public/images/login-mountain.jpg
```
  (Sediakan file sesuai gambar contoh Anda agar tampilan identik.)

Jika logo tidak ditemukan, sistem akan menggunakan placeholder SVG.

### 4. Konfigurasi Social Login (Google & Facebook)
Edit file `.env` dan isi kredensial Anda:

```
GOOGLE_CLIENT_ID=YOUR_GOOGLE_CLIENT_ID
GOOGLE_CLIENT_SECRET=YOUR_GOOGLE_CLIENT_SECRET
GOOGLE_REDIRECT_URI=http://localhost:8080/auth/google/callback

FACEBOOK_CLIENT_ID=YOUR_FACEBOOK_APP_ID
FACEBOOK_CLIENT_SECRET=YOUR_FACEBOOK_APP_SECRET
FACEBOOK_REDIRECT_URI=http://localhost:8080/auth/facebook/callback
```

Perbarui whitelist email admin pada `app/Config/SocialAuth.php` jika diperlukan (`$allowedEmails`).

### 5. Akses Halaman Login
Buka browser dan akses:
```
http://localhost:8080/login
```

### 6. Setelah Login Berhasil
Setelah login berhasil, Anda akan otomatis diarahkan ke:
```
http://localhost:8080/admin/news
```

## Fitur Login

- ✅ Validasi username dan password
- ✅ Hanya admin yang bisa login
- ✅ Remember me functionality
- ✅ Password visibility toggle
- ✅ Demo credentials button
- ✅ Redirect otomatis setelah login
- ✅ Session management
- ✅ Logout functionality
- ✅ Protected admin routes

## Keamanan

- Password di-hash menggunakan `password_hash()` dengan PASSWORD_DEFAULT
- CSRF protection (dapat diaktifkan di `app/Config/Filters.php`)
- Session-based authentication
- Role-based access control (hanya admin)


