<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateUsers extends Migration
{
	public function up()
	{
		// Membuat kolom/field untuk tabel users
		$this->forge->addField([
			'id'          => [
				'type'           => 'INT',
				'constraint'     => 5,
				'unsigned'       => true,
				'auto_increment' => true
			],
			'username'       => [
				'type'           => 'VARCHAR',
				'constraint'     => '100',
				'unique'         => true
			],
			'password'      => [
				'type'           => 'VARCHAR',
				'constraint'     => 255,
			],
			'name'      => [
				'type'           => 'VARCHAR',
				'constraint'     => 100,
			],
			'email'      => [
				'type'           => 'VARCHAR',
				'constraint'     => 100,
				'null'           => true,
			],
			'role'      => [
				'type'           => 'ENUM',
				'constraint'     => ['admin', 'user'],
				'default'        => 'user',
			],
			'created_at DATETIME DEFAULT CURRENT_TIMESTAMP',
			'updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
		]);

		// Membuat primary key
		$this->forge->addKey('id', TRUE);

		// Membuat tabel users
		$this->forge->createTable('users', TRUE);
	}

	//---------------------

	public function down()
	{
		// menghapus tabel users
		$this->forge->dropTable('users');
	}
}









