<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use CodeIgniter\I18n\Time;

class NewsLatestSeeder extends Seeder
{
    public function run()
    {
        $now = Time::now()->toDateTimeString();
        $author = 'Tim Redaksi';

        $newsData = [
            [
                'title'   => 'CodeIgniter 4.4 Dirilis: Fitur Baru dan Peningkatan Keamanan',
                'slug'    => 'codeigniter-4-4-rilis',
                'content' => 'Tim pengembang CodeIgniter merilis versi 4.4 dengan peningkatan kinerja lintas modul dan patch keamanan penting yang sangat direkomendasikan bagi seluruh pengguna.',
            ],
            [
                'title'   => 'Tren Pengembangan Web 2026: Dari AI hingga Framework PHP',
                'slug'    => 'tren-pengembangan-web-2026',
                'content' => 'Integrasi AI dalam alur kerja developer dan adopsi framework ringan seperti CodeIgniter diprediksi mendominasi lanskap teknologi pada 2026.',
            ],
            [
                'title'   => 'Tips dan Trik Mengoptimalkan Query Database di CodeIgniter',
                'slug'    => 'tips-optimasi-query-codeigniter',
                'content' => 'Pelajari teknik Query Builder, caching, dan cara menghindari N+1 problem untuk menjaga performa aplikasi CodeIgniter Anda tetap kencang.',
            ],
            [
                'title'   => 'Mengenal Lebih Dekat Fitur Migrasi Database CodeIgniter',
                'slug'    => 'fitur-migrasi-database-codeigniter',
                'content' => 'Fitur migrasi CodeIgniter membantu tim developer mengatur perubahan skema secara terstruktur sehingga deployment lebih aman.',
            ],
            [
                'title'   => 'Studi Kasus: Membangun API Cepat dengan CodeIgniter 4',
                'slug'    => 'studi-kasus-api-codeigniter-4',
                'content' => 'CodeIgniter 4 terbukti tangguh untuk RESTful API. Simak langkah dan best practice untuk membangun layanan berkecepatan tinggi.',
            ],
            [
                'title'   => 'Pentingnya Pengujian Unit dalam Aplikasi CodeIgniter',
                'slug'    => 'pentingnya-unit-testing-codeigniter',
                'content' => 'Gunakan tool bawaan CodeIgniter untuk memastikan tiap komponen aplikasi lolos uji dan mudah dipelihara.',
            ],
            [
                'title'   => 'Membandingkan CodeIgniter dengan Framework PHP Populer Lainnya',
                'slug'    => 'membandingkan-codeigniter-dengan-framework-lain',
                'content' => 'CodeIgniter menonjol karena ringan dan cepat. Artikel ini mengulas perbandingannya dengan framework PHP populer lainnya.',
            ],
            [
                'title'   => 'Keuntungan Menggunakan Composer untuk CodeIgniter',
                'slug'    => 'keuntungan-composer-untuk-codeigniter',
                'content' => 'Composer mempermudah pengelolaan library pihak ketiga. Lihat bagaimana integrasinya di proyek CodeIgniter.',
            ],
            [
                'title'   => 'Cara Aman Menerapkan Otentikasi Pengguna di CodeIgniter',
                'slug'    => 'cara-aman-otentikasi-codeigniter',
                'content' => 'Panduan langkah demi langkah untuk membangun sistem login yang aman dengan fitur bawaan CodeIgniter dan standar keamanan terbaru.',
            ],
            [
                'title'   => 'Komunitas CodeIgniter Indonesia Mengadakan Gathering Akbar',
                'slug'    => 'komunitas-codeigniter-gathering-akbar',
                'content' => 'Pertemuan akbar komunitas CodeIgniter Indonesia menghadirkan workshop dan diskusi seputar masa depan pengembangan web.',
            ],
        ];

        foreach ($newsData as $data) {
            $this->db->table('news')->insert([
                'title'      => $data['title'],
                'slug'       => $data['slug'],
                'content'    => $data['content'],
                'status'     => 'published',
                'author'     => $author,
                'created_at' => $now,
            ]);
        }
    }
}








