<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f0eb;
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
    }

    /* Content wrapper */
    .form-wrapper {
        position: relative;
        z-index: 1;
        padding: 40px 20px;
    }

    .form-container {
        max-width: 900px;
        margin: 0 auto;
    }

    /* Form card */
    .form-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-radius: 25px;
        padding: 2rem;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(255, 255, 255, 0.3);
    }

    /* Page header */
    .page-header {
        text-align: center;
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 1px solid #e3ded6;
        position: relative;
    }

    .page-header::after {
        content: '';
        position: absolute;
        bottom: -1px;
        left: 50%;
        transform: translateX(-50%);
        width: 80px;
        height: 3px;
        background: linear-gradient(90deg, #6b3c3c, #005f62);
        border-radius: 2px;
    }

    .page-header h2 {
        color: #333;
        font-weight: 600;
        font-size: 1.6rem;
        margin-bottom: 0.5rem;
        letter-spacing: 0.02em;
    }

    .page-header i {
        color: #005f62;
        font-size: 2rem;
        margin-bottom: 0.75rem;
        display: block;
    }

    .page-header p {
        color: #666;
        font-size: 0.95rem;
        margin: 0;
    }


    /* Alert styling */
    .alert {
        border-radius: 10px;
        border: none;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        margin-bottom: 1.5rem;
    }

    .alert-danger {
        background: rgba(220, 53, 69, 0.9);
        color: white;
    }

    /* Form group styling */
    .form-group {
        margin-bottom: 2rem;
    }

    .form-group label {
        font-weight: 600;
        color: #1a1a2e;
        margin-bottom: 0.75rem;
        display: block;
        font-size: 0.95rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }

    .form-group label i {
        color: #005f62;
        margin-right: 0.5rem;
        font-size: 1rem;
    }

    .form-group label .text-danger {
        color: #dc3545;
    }

    .form-control {
        border: 2px solid rgba(0, 0, 0, 0.1);
        border-radius: 12px;
        padding: 12px 16px;
        font-size: 0.95rem;
        transition: all 0.3s ease;
        background: #fff;
        width: 100%;
    }

    .form-control:focus {
        border-color: #005f62;
        box-shadow: 0 0 0 3px rgba(0, 95, 98, 0.1);
        outline: none;
        background: #fff;
    }

    .form-control::placeholder {
        color: #999;
        font-style: italic;
    }

    /* Textarea specific styling */
    textarea.form-control {
        min-height: 300px;
        resize: vertical;
        font-family: inherit;
        line-height: 1.7;
    }

    textarea.form-control:focus {
        min-height: 350px;
    }

    /* Character counter */
    .char-counter {
        text-align: right;
        font-size: 0.85rem;
        color: #999;
        margin-top: 0.5rem;
    }

    .char-counter.warning {
        color: #ff9800;
    }

    .char-counter.danger {
        color: #dc3545;
    }

    /* Button group */
    .btn-group-custom {
        display: flex;
        gap: 0.75rem;
        margin-top: 2rem;
        padding-top: 1.5rem;
        border-top: 1px solid #e3ded6;
        justify-content: center;
    }

    .btn-custom {
        padding: 10px 20px;
        border-radius: 8px;
        font-weight: 600;
        font-size: 0.85rem;
        border: none;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        text-decoration: none;
        cursor: pointer;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.15);
    }

    .btn-custom i {
        font-size: 0.9rem;
    }

    .btn-primary-custom {
        background-color: #005f62;
        color: white;
    }

    .btn-primary-custom:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 15px rgba(0, 95, 98, 0.4);
        color: white;
        text-decoration: none;
        background-color: #004a4d;
    }

    .btn-secondary-custom {
        background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
        color: white;
    }

    .btn-secondary-custom:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 15px rgba(108, 117, 125, 0.4);
        color: white;
        text-decoration: none;
        background: linear-gradient(135deg, #5a6268 0%, #495057 100%);
    }

    .btn-danger-custom {
        background: #8b0000;
        color: white;
    }

    .btn-danger-custom:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 15px rgba(139, 0, 0, 0.4);
        color: white;
        text-decoration: none;
        background: #a52a2a;
    }

    /* Form tips */
    .form-tips {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 12px;
        padding: 1.25rem;
        margin-top: 1.5rem;
        border-left: 4px solid #005f62;
    }

    .form-tips h6 {
        color: #005f62;
        font-weight: 600;
        margin-bottom: 0.75rem;
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }

    .form-tips ul {
        margin: 0;
        padding-left: 1.25rem;
        color: #666;
        font-size: 0.9rem;
        line-height: 1.8;
    }

    .form-tips ul li {
        margin-bottom: 0.5rem;
    }

    /* News info */
    .news-info {
        background: #f4f0eb;
        border-radius: 12px;
        padding: 1.25rem;
        margin-bottom: 1.5rem;
        border-left: 5px solid #6b3c3c;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        border: 1px solid #e3ded6;
    }

    .news-info h6 {
        color: #333;
        font-weight: 700;
        margin-bottom: 1rem;
        font-size: 0.95rem;
        text-transform: uppercase;
        letter-spacing: 0.1em;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .news-info h6 i {
        background: rgba(107, 60, 60, 0.2);
        color: #6b3c3c;
        padding: 0.4rem;
        border-radius: 50%;
        font-size: 1rem;
    }

    .news-info p {
        margin: 0.75rem 0;
        color: #555;
        font-size: 0.9rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
        padding: 0.4rem;
        border-radius: 6px;
        transition: background 0.3s ease;
    }

    .news-info p:hover {
        background: rgba(107, 60, 60, 0.1);
    }

    .news-info p i {
        color: #6b3c3c;
        margin-right: 0;
        width: 18px;
        font-size: 0.9rem;
    }

    .news-info code {
        background: rgba(107, 60, 60, 0.15);
        color: #6b3c3c;
        padding: 0.2rem 0.4rem;
        border-radius: 5px;
        font-size: 0.85rem;
        font-weight: 600;
        border: 1px solid rgba(107, 60, 60, 0.3);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .form-wrapper {
            padding: 20px 15px;
        }

        .form-card {
            padding: 1.5rem;
            border-radius: 20px;
        }

        .page-header h2 {
            font-size: 1.5rem;
        }

        .page-header i {
            font-size: 2rem;
        }

        .btn-group-custom {
            flex-direction: column;
        }

        .btn-custom {
            width: 100%;
        }

        textarea.form-control {
            min-height: 250px;
        }

        textarea.form-control:focus {
            min-height: 300px;
        }
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="form-wrapper">
    <div class="form-container">
        <div class="form-card">
            <div class="page-header">
                <i class="fas fa-edit"></i>
                <h2>Edit Berita</h2>
                <p>Perbarui informasi berita Anda</p>
            </div>

            <?php if (session()->getFlashdata('errors')): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                            <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if(isset($news)): ?>
            <div class="news-info">
                <h6><i class="fas fa-info-circle"></i> Informasi Berita</h6>
                <?php if(isset($news['created_at'])): ?>
                    <p><i class="fas fa-calendar-plus"></i> Dibuat: <?= date('d M Y, H:i', strtotime($news['created_at'])) ?></p>
                <?php endif; ?>
                <?php if(isset($news['updated_at'])): ?>
                    <p><i class="fas fa-calendar-check"></i> Diperbarui: <?= date('d M Y, H:i', strtotime($news['updated_at'])) ?></p>
                <?php endif; ?>
                <?php if(isset($news['slug'])): ?>
                    <p><i class="fas fa-link"></i> Slug: <code><?= esc($news['slug']) ?></code></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <form action="" method="post" id="text-editor">
                <?= csrf_field() ?>
                <input type="hidden" name="id" value="<?= isset($news['id']) ? $news['id'] : '' ?>" />
                
                <div class="form-group">
                    <label for="title">
                        <i class="fas fa-heading"></i> Judul Berita <span class="text-danger">*</span>
                    </label>
                    <input type="text" 
                           name="title" 
                           id="title" 
                           class="form-control" 
                           placeholder="Masukkan judul berita yang menarik..." 
                           value="<?= isset($news['title']) ? esc($news['title']) : '' ?>" 
                           required
                           maxlength="200">
                    <div class="char-counter">
                        <span id="title-char-count"><?= isset($news['title']) ? strlen($news['title']) : 0 ?></span>/200 karakter
                    </div>
                </div>

                <div class="form-group">
                    <label for="content">
                        <i class="fas fa-align-left"></i> Konten Berita <span class="text-danger">*</span>
                    </label>
                    <textarea name="content" 
                              id="content" 
                              class="form-control" 
                              cols="30" 
                              rows="10" 
                              placeholder="Tulis konten berita Anda di sini. Gunakan paragraf yang jelas dan mudah dibaca..."
                              required><?= isset($news['content']) ? esc($news['content']) : '' ?></textarea>
                    <div class="char-counter">
                        <span id="content-char-count"><?= isset($news['content']) ? strlen($news['content']) : 0 ?></span> karakter
                    </div>
                </div>

                <div class="form-tips">
                    <h6><i class="fas fa-lightbulb"></i> Tips Menulis Berita</h6>
                    <ul>
                        <li>Gunakan judul yang menarik dan informatif</li>
                        <li>Mulai dengan paragraf pembuka yang kuat</li>
                        <li>Gunakan paragraf pendek untuk keterbacaan yang lebih baik</li>
                        <li>Periksa ejaan dan tata bahasa sebelum mempublish</li>
                    </ul>
                </div>

                <div class="btn-group-custom">
                    <button type="submit" 
                            name="status" 
                            value="published" 
                            class="btn-custom btn-primary-custom">
                        <i class="fas fa-paper-plane"></i>
                        Update & Publish
                    </button>
                    <button type="submit" 
                            name="status" 
                            value="draft" 
                            class="btn-custom btn-secondary-custom">
                        <i class="fas fa-save"></i>
                        Simpan sebagai Draft
                    </button>
                    <a href="<?= base_url('admin/news') ?>" 
                       class="btn-custom btn-danger-custom">
                        <i class="fas fa-times"></i>
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Character counter for title and content
document.addEventListener('DOMContentLoaded', function() {
    const titleInput = document.getElementById('title');
    const titleCharCount = document.getElementById('title-char-count');
    const contentTextarea = document.getElementById('content');
    const contentCharCount = document.getElementById('content-char-count');

    if (titleInput && titleCharCount) {
        // Update initial count
        titleCharCount.textContent = titleInput.value.length;
        
        titleInput.addEventListener('input', function() {
            const length = this.value.length;
            titleCharCount.textContent = length;
            
            // Update counter color based on length
            const counter = this.nextElementSibling;
            counter.classList.remove('warning', 'danger');
            if (length > 150) {
                counter.classList.add('warning');
            }
            if (length >= 200) {
                counter.classList.add('danger');
            }
        });
    }

    if (contentTextarea && contentCharCount) {
        // Update initial count
        contentCharCount.textContent = contentTextarea.value.length;
        
        contentTextarea.addEventListener('input', function() {
            const length = this.value.length;
            contentCharCount.textContent = length;
        });
    }
});
</script>

<?= $this->endSection() ?>
