<?= $this->extend('layout/news_layout') ?>

<?= $this->section('content') ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f0eb;
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
    }

    /* Content wrapper */
    .news-wrapper {
        position: relative;
        z-index: 1;
        padding: 40px 20px 60px;
    }

    .news-container {
        max-width: 1200px;
        margin: 0 auto;
    }

    /* News card styling */
    .news-card {
        background: white;
        border-radius: 15px;
        padding: 2.5rem;
        margin-bottom: 2rem;
        border: 2px solid #f4f0eb;
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        overflow: hidden;
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .news-card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 5px;
        height: 100%;
        background: linear-gradient(180deg, #6b3c3c 0%, #005f62 100%);
        transform: scaleY(0);
        transform-origin: top;
        transition: transform 0.4s ease;
    }

    .news-card:nth-child(odd)::before {
        background: linear-gradient(180deg, #6b3c3c 0%, #8b4513 100%);
    }

    .news-card:nth-child(even)::before {
        background: linear-gradient(180deg, #005f62 0%, #004a4d 100%);
    }

    .news-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 50px rgba(107, 60, 60, 0.15);
        border-color: #e8e0d5;
    }

    .news-card:hover::before {
        transform: scaleY(1);
    }

    .news-card h5 {
        margin-bottom: 1rem;
        position: relative;
        padding-left: 1rem;
    }

    .news-card h5::before {
        content: "";
        position: absolute;
        left: 0;
        top: 50%;
        transform: translateY(-50%);
        width: 4px;
        height: 60%;
        background: linear-gradient(180deg, #6b3c3c 0%, #005f62 100%);
        border-radius: 2px;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .news-card:nth-child(odd) h5::before {
        background: linear-gradient(180deg, #6b3c3c 0%, #8b4513 100%);
    }

    .news-card:nth-child(even) h5::before {
        background: linear-gradient(180deg, #005f62 0%, #004a4d 100%);
    }

    .news-card:hover h5::before {
        opacity: 1;
    }

    .news-card h5 a {
        color: #333;
        text-decoration: none;
        font-size: 1.6rem;
        font-weight: 700;
        line-height: 1.4;
        transition: all 0.3s ease;
        display: block;
    }

    .news-card:nth-child(odd) h5 a:hover {
        color: #6b3c3c;
    }

    .news-card:nth-child(even) h5 a:hover {
        color: #005f62;
    }

    .news-card p {
        color: #555;
        font-size: 1.05rem;
        line-height: 1.8;
        margin-bottom: 1.5rem;
        padding-left: 1rem;
    }

    .news-meta {
        display: flex;
        align-items: center;
        flex-wrap: wrap;
        gap: 1.25rem;
        color: #666;
        font-size: 0.9rem;
        margin-top: 1.5rem;
        padding-top: 1.5rem;
        border-top: 2px solid #f4f0eb;
        padding-left: 1rem;
    }

    .news-meta span {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .news-meta i {
        font-size: 1rem;
    }

    .news-card:nth-child(odd) .news-meta i {
        color: #6b3c3c;
    }

    .news-card:nth-child(even) .news-meta i {
        color: #005f62;
    }

    .read-more {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        font-weight: 600;
        text-decoration: none;
        margin-top: 1rem;
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        transition: all 0.3s ease;
        margin-left: 1rem;
    }

    .news-card:nth-child(odd) .read-more {
        color: #6b3c3c;
        background: rgba(107, 60, 60, 0.1);
    }

    .news-card:nth-child(even) .read-more {
        color: #005f62;
        background: rgba(0, 95, 98, 0.1);
    }

    .read-more:hover {
        gap: 0.75rem;
        text-decoration: none;
        transform: translateX(5px);
    }

    .news-card:nth-child(odd) .read-more:hover {
        background: rgba(107, 60, 60, 0.15);
        color: #8b4513;
    }

    .news-card:nth-child(even) .read-more:hover {
        background: rgba(0, 95, 98, 0.15);
        color: #004a4d;
    }

    .read-more i {
        transition: transform 0.3s ease;
    }

    .read-more:hover i {
        transform: translateX(5px);
    }

    /* Empty state */
    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        background: white;
        border-radius: 15px;
        color: #666;
        border: 2px solid #f4f0eb;
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
    }

    .empty-state i {
        font-size: 4rem;
        color: #ccc;
        margin-bottom: 1rem;
    }

    .empty-state h4 {
        color: #6b3c3c;
        margin-bottom: 0.5rem;
    }

    /* Stagger animation for cards */
    .news-card:nth-child(1) { animation-delay: 0.1s; }
    .news-card:nth-child(2) { animation-delay: 0.2s; }
    .news-card:nth-child(3) { animation-delay: 0.3s; }
    .news-card:nth-child(4) { animation-delay: 0.4s; }
    .news-card:nth-child(5) { animation-delay: 0.5s; }
    .news-card:nth-child(6) { animation-delay: 0.6s; }

    /* Responsive */
    @media (max-width: 768px) {
        .news-wrapper {
            padding: 20px 15px 40px;
        }

        .news-card {
            padding: 1.75rem;
        }

        .news-card h5 a {
            font-size: 1.3rem;
        }

        .news-card p {
            font-size: 1rem;
        }

        .news-meta {
            gap: 1rem;
            font-size: 0.85rem;
        }
    }
</style>

<div class="news-wrapper">
    <div class="news-container">
        <?php if (empty($newses)): ?>
            <div class="empty-state">
                <i class="fas fa-newspaper"></i>
                <h4>Belum ada berita</h4>
                <p>Berita akan muncul di sini</p>
            </div>
        <?php else: ?>
            <?php foreach ($newses as $index => $news) : ?>
                <div class="news-card">
                    <h5>
                        <a href="/news/<?= $news['slug'] ?>">
                            <?= esc($news['title']) ?>
                        </a>
                    </h5>
                    <p><?= esc(substr(strip_tags($news['content']), 0, 200)) ?>...</p>
                    <div class="news-meta">
                        <span><i class="fas fa-calendar-alt"></i> <?= date('d M Y', strtotime($news['created_at'])) ?></span>
                        <span><i class="fas fa-user"></i> <?= esc($news['author'] ?? 'Admin') ?></span>
                        <?php if($news['status'] === 'published'): ?>
                            <span><i class="fas fa-check-circle"></i> Published</span>
                        <?php endif; ?>
                    </div>
                    <a href="/news/<?= $news['slug'] ?>" class="read-more">
                        Baca Selengkapnya <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            <?php endforeach ?>
        <?php endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const cards = document.querySelectorAll('.news-card');
    cards.forEach((card, index) => {
        card.style.animationDelay = (index * 0.1) + 's';
        card.style.opacity = '1';
    });
});
</script>

<?= $this->endSection() ?>
