<?= $this->extend('layout/pegawai_layout') ?>

<?= $this->section('content') ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f0eb;
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
    }

    /* Content wrapper */
    .pegawai-wrapper {
        position: relative;
        z-index: 1;
        padding: 80px 20px 60px;
    }

    /* Hero Section */
    .pegawai-hero {
        text-align: center;
        margin-bottom: 3rem;
        padding: 32px 20px;
        background: #f8f5f0;
        border-radius: 24px;
        border: 1px solid #e3ded6;
        box-shadow: 0 12px 30px rgba(0, 0, 0, 0.05);
        max-width: 900px;
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 3rem;
        animation: fadeInDown 0.8s ease;
    }

    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .pegawai-hero h1 {
        font-size: 2.5rem;
        font-weight: 600;
        color: #333;
        margin-bottom: 1rem;
        text-shadow: 0 2px 20px rgba(255, 255, 255, 0.3);
        letter-spacing: -1px;
    }

    .pegawai-hero p {
        color: #666;
        font-size: 1.15rem;
        max-width: 700px;
        margin: 0 auto;
        line-height: 1.8;
        font-weight: 400;
    }

    /* Grid Container */
    .pegawai-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 16px;
    }

    .pegawai-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
        gap: 1.5rem;
        animation: fadeInUp 1s ease;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Card Styles */
    .pegawai-card {
        border: none;
        border-radius: 24px;
        overflow: hidden;
        background: rgba(255, 255, 255, 0.96);
        backdrop-filter: blur(18px);
        -webkit-backdrop-filter: blur(18px);
        box-shadow: 0 14px 40px rgba(0, 0, 0, 0.18),
                    0 0 0 1px rgba(255, 255, 255, 0.3) inset;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        cursor: pointer;
    }

    .pegawai-card::before {
        content: "";
        position: absolute;
        inset: 0;
        border-radius: 30px;
        padding: 2px;
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.5), rgba(118, 75, 162, 0.5));
        -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
        mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
        -webkit-mask-composite: xor;
        mask-composite: exclude;
        opacity: 0;
        transition: opacity 0.4s ease;
        z-index: 1;
    }

    .pegawai-card:hover {
        transform: translateY(-15px) scale(1.02);
        box-shadow: 0 30px 80px rgba(0, 0, 0, 0.3),
                    0 0 0 1px rgba(255, 255, 255, 0.5) inset;
    }

    .pegawai-card:hover::before {
        opacity: 1;
    }

    .pegawai-card img,
    .pegawai-card .avatar-placeholder {
        width: 100%;
        height: 180px; /* gambar sedikit diperkecil */
        object-fit: cover;
        transition: transform 0.4s ease;
        border-radius: 20px 20px 0 0;
    }

    .pegawai-card:hover img {
        transform: scale(1.1);
    }

    .avatar-placeholder {
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        position: relative;
        overflow: hidden;
    }

    .avatar-placeholder::before {
        content: "";
        position: absolute;
        inset: -50%;
        background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        animation: shine 3s infinite;
    }

    @keyframes shine {
        0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
        100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
    }

    .avatar-placeholder i {
        font-size: 5rem;
        color: rgba(255, 255, 255, 0.9);
        z-index: 1;
    }

    .pegawai-card .card-body {
        padding: 1.25rem 1.5rem 1.5rem;
        position: relative;
    }

    .pegawai-card h5 {
        font-weight: 700;
        color: #1a1a2e;
        margin-bottom: 0.75rem;
        font-size: 1.25rem;
        letter-spacing: -0.5px;
    }

    .pegawai-meta {
        display: flex;
        flex-direction: column;
        gap: 0.35rem;
        font-size: 0.9rem;
        color: #555;
    }

    .pegawai-meta strong {
        color: #667eea;
        font-weight: 600;
    }

    .pegawai-meta div {
        padding: 0.25rem 0;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }

    .pegawai-meta div:last-child {
        border-bottom: none;
    }

    /* Empty State */
    .pegawai-empty {
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.9), rgba(240, 240, 255, 0.95));
        backdrop-filter: blur(20px);
        border: none;
        border-radius: 24px;
        padding: 2.5rem 2rem;
        text-align: center;
        color: #444;
        font-size: 1rem;
        box-shadow: 0 18px 45px rgba(0, 0, 0, 0.18);
        max-width: 700px;
        margin: 0 auto 2rem;
    }

    .pegawai-empty h3 {
        font-size: 1.8rem;
        font-weight: 700;
        margin-bottom: 0.75rem;
        color: #1a1a2e;
    }

    .pegawai-empty p {
        margin-bottom: 0.75rem;
    }

    .pegawai-empty .empty-divisions {
        display: flex;
        justify-content: center;
        gap: 0.75rem;
        margin: 1rem 0 0.5rem;
        flex-wrap: wrap;
    }

    .pegawai-empty .empty-pill {
        padding: 0.35rem 1.1rem;
        border-radius: 999px;
        background: linear-gradient(135deg, #667eea, #4facfe);
        color: #fff;
        font-size: 0.85rem;
        font-weight: 600;
        box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
    }

    .pegawai-empty .empty-hint {
        font-size: 0.9rem;
        color: #777;
        margin-top: 0.5rem;
    }

    /* Per-division empty state */
    .division-empty-note {
        margin-top: 1.5rem;
        text-align: center;
        font-size: 0.95rem;
        color: rgba(255, 255, 255, 0.95);
        background: rgba(15, 23, 42, 0.35);
        border-radius: 18px;
        padding: 1rem 1.5rem;
        border: 1px dashed rgba(148, 163, 184, 0.7);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .pegawai-hero h1 {
            font-size: 2.5rem;
        }

        .pegawai-hero p {
            font-size: 1rem;
        }

        .pegawai-grid {
            grid-template-columns: 1fr;
            gap: 1.5rem;
        }

        .pegawai-wrapper {
            padding: 60px 15px 40px;
        }
    }

    /* Stagger animation for cards */
    .pegawai-card:nth-child(1) { animation-delay: 0.1s; }
    .pegawai-card:nth-child(2) { animation-delay: 0.2s; }
    .pegawai-card:nth-child(3) { animation-delay: 0.3s; }
    .pegawai-card:nth-child(4) { animation-delay: 0.4s; }
    .pegawai-card:nth-child(5) { animation-delay: 0.5s; }
    .pegawai-card:nth-child(6) { animation-delay: 0.6s; }

    /* Division Tabs */
    .search-filter-bar {
        display: flex;
        flex-wrap: wrap;
        gap: 0.75rem;
        justify-content: center;
        margin-bottom: 1.5rem;
    }

    .search-input {
        flex: 0 0 auto;
    }

    .search-input input {
        width: 370px;
        border-radius: 999px;
        border: none;
        padding: 0.55rem 1.5rem;
        font-size: 0.95rem;
        box-shadow: 0 8px 20px rgba(15, 23, 42, 0.2);
    }

    .search-input input:focus {
        outline: none;
        box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.6);
    }

    .gender-select select {
        border-radius: 999px;
        border: none;
        padding: 0.55rem 1.1rem;
        font-size: 0.95rem;
        box-shadow: 0 8px 20px rgba(15, 23, 42, 0.2);
    }

    .search-filter-bar button[type="submit"] {
        border-radius: 999px;
        border: none;
        padding: 0.55rem 1.4rem;
        font-size: 0.95rem;
        font-weight: 600;
        background-color: #005f62;
        color: #fff;
        box-shadow: 0 10px 22px rgba(0, 95, 98, 0.5);
        cursor: pointer;
        transition: all 0.25s ease;
    }

    .search-filter-bar button[type="submit"]:hover {
        transform: translateY(-1px);
        box-shadow: 0 12px 30px rgba(0, 95, 98, 0.6);
    }

    .division-tabs {
        display: inline-flex;
        justify-content: center;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 2.5rem;
        padding: 0.35rem;
        border-radius: 999px;
        background: rgba(255, 255, 255, 0.96);
        box-shadow: 0 14px 40px rgba(15, 23, 42, 0.25);
    }

    .division-tabs-wrapper {
        display: flex;
        justify-content: center;
        margin-bottom: 2.5rem;
    }

    .division-tab {
        padding: 0.6rem 1.7rem;
        border-radius: 999px;
        border: none;
        background: transparent;
        color: #1f2933;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.25s ease;
        min-width: 110px;
        text-align: center;
        font-size: 0.95rem;
    }

    .division-tab.active {
        background: linear-gradient(135deg, #6b3c3c 0%, #4d2a2a 100%);
        color: #fff;
        box-shadow: 0 10px 25px rgba(75, 34, 34, 0.55);
        transform: translateY(-1px);
    }

    .division-tab:hover {
        transform: translateY(-1px);
    }

    .division-footer {
        margin-top: 1.75rem;
        text-align: center;
        font-size: 0.95rem;
        color: #4b3a2f;
        font-weight: 500;
    }
</style>

<div class="pegawai-wrapper">
    <div class="pegawai-container">
        <div class="pegawai-hero">
            <h1>Data Pegawai</h1>
            <p>Pilih salah satu divisi di bawah untuk melihat daftar anggota tim yang bertanggung jawab pada bidangnya masing-masing.</p>
        </div>

        <?php
            // Kelompokkan pegawai berdasarkan divisi
            $groups = [
                'IT' => [],
                'HR' => [],
                'Produksi' => [],
                'Marketing' => [],
            ];

            foreach ($pegawai as $p) {
                $div = trim($p['divisi'] ?? '');
                if (isset($groups[$div])) {
                    $groups[$div][] = $p;
                }
            }

            $hasAny = array_reduce($groups, fn($carry, $items) => $carry || !empty($items), false);
        ?>

        <form class="search-filter-bar" method="get" action="<?= base_url('pegawai') ?>">
            <div class="search-input">
                <input
                    type="text"
                    name="q"
                    value="<?= esc($keyword ?? '') ?>"
                    placeholder="Cari nama, tanggal lahir, gender, atau divisi..."
                >
            </div>
            <div class="gender-select">
                <select name="gender">
                    <option value="semua" <?= ($gender ?? 'semua') === 'semua' ? 'selected' : '' ?>>Semua Jenis Kelamin</option>
                    <option value="Laki-laki" <?= ($gender ?? '') === 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= ($gender ?? '') === 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
            <button type="submit">Terapkan</button>
        </form>

        <div class="division-tabs-wrapper">
            <div class="division-tabs">
                <?php foreach (['IT', 'HR', 'Produksi', 'Marketing'] as $index => $divisi): ?>
                    <button class="division-tab <?= $index === 0 ? 'active' : '' ?>" data-divisi="<?= $divisi ?>">
                        <?= $divisi ?>
                    </button>
                <?php endforeach; ?>
            </div>
        </div>

        <?php if (!$hasAny): ?>
            <div class="alert alert-info pegawai-empty">
                <h3>Data Pegawai Masih Kosong</h3>
                <p>Belum ada pegawai yang terdaftar pada divisi di bawah ini.</p>
                <div class="empty-divisions">
                    <span class="empty-pill">IT</span>
                    <span class="empty-pill">HR</span>
                    <span class="empty-pill">Produksi</span>
                    <span class="empty-pill">Marketing</span>
                </div>
                <p class="empty-hint">
                    Silakan tambahkan data pegawai melalui halaman admin agar tim terbaik Anda tampil pada setiap divisi.
                </p>
            </div>
        <?php else: ?>
            <div class="pegawai-grid">
                <?php foreach (['IT', 'HR', 'Produksi', 'Marketing'] as $divisi): ?>
                    <?php foreach ($groups[$divisi] as $p): ?>
                    <div class="pegawai-card" data-divisi="<?= $divisi ?>">
                        <?php if ($p['foto_pegawai']): ?>
                            <img src="<?= base_url('uploads/pegawai/' . $p['foto_pegawai']) ?>" alt="<?= esc($p['nama_pegawai']) ?>">
                        <?php else: ?>
                            <div class="avatar-placeholder">
                                <i class="fas fa-user"></i>
                            </div>
                        <?php endif; ?>
                        <div class="card-body">
                            <h5><?= esc($p['nama_pegawai']) ?></h5>
                            <div class="pegawai-meta">
                                <?php if (!empty($p['tanggal_lahir'] ?? '')): ?>
                                    <div><strong>Tanggal Lahir:</strong> <?= date('d-m-Y', strtotime($p['tanggal_lahir'])) ?></div>
                                <?php endif; ?>
                                <div><strong>Jenis Kelamin:</strong> <?= esc($p['jenis_kelamin']) ?></div>
                                <div><strong>Divisi:</strong> <?= esc($p['divisi'] ?? '-') ?></div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php endforeach; ?>
            </div>

            <div class="division-footer" data-role="footer">
                Menampilkan daftar anggota Divisi IT yang telah terdaftar pada sistem.
            </div>
            <div class="division-empty-note" data-role="division-empty" style="display:none;"></div>
        <?php endif; ?>
    </div>
</div>

<script>
    (function() {
        const tabs = document.querySelectorAll('.division-tab');
        const cards = document.querySelectorAll('.pegawai-card');
        const footerEl = document.querySelector('[data-role="footer"]');
        const emptyEl = document.querySelector('[data-role="division-empty"]');

        const divisionTexts = {
            'IT': {
                footer: 'Menampilkan daftar anggota Divisi IT yang telah terdaftar pada sistem.',
                empty: 'Belum ada pegawai yang terdaftar pada Divisi IT. Tambahkan data melalui halaman admin untuk mulai membangun tim IT Anda.'
            },
            'HR': {
                footer: 'Menampilkan daftar anggota Divisi HR yang telah terdaftar pada sistem.',
                empty: 'Belum ada pegawai yang terdaftar pada Divisi HR. Tambahkan data pegawai untuk mulai menyusun struktur tim HR.'
            },
            'Produksi': {
                footer: 'Menampilkan daftar anggota Divisi Produksi yang telah terdaftar pada sistem.',
                empty: 'Belum ada pegawai yang terdaftar pada Divisi Produksi. Tambahkan data untuk mendokumentasikan tim pelaksana di lapangan.'
            },
            'Marketing': {
                footer: 'Menampilkan daftar anggota Divisi Marketing yang telah terdaftar pada sistem.',
                empty: 'Belum ada pegawai yang terdaftar pada Divisi Marketing. Tambahkan data untuk menampilkan tim yang mengelola promosi dan branding.'
            }
        };

        function applyFilter(divisi) {
            let visibleCount = 0;
            cards.forEach(card => {
                if (card.dataset.divisi === divisi) {
                    card.style.display = '';
                    visibleCount++;
                } else {
                    card.style.display = 'none';
                }
            });

            const cfg = divisionTexts[divisi];
            if (cfg && footerEl) {
                footerEl.textContent = cfg.footer;
            }

            if (emptyEl) {
                if (visibleCount === 0 && cfg && cfg.empty) {
                    emptyEl.textContent = cfg.empty;
                    emptyEl.style.display = '';
                } else {
                    emptyEl.style.display = 'none';
                    emptyEl.textContent = '';
                }
            }
        }

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                tabs.forEach(t => t.classList.remove('active'));
                tab.classList.add('active');
                applyFilter(tab.dataset.divisi);
            });
        });

        // Set default filter ke IT
        applyFilter('IT');
    })();
</script>

<?= $this->endSection() ?>


