<?php

namespace App\Controllers;

class Auth extends BaseController
{
    public function login()
    {
        if (session()->get('isLoggedIn')) {
            return redirect()->to('/admin');
        }

        return view('auth/login', [
            'title' => 'Login Admin',
            'validation' => \Config\Services::validation()
        ]);
    }

    public function attemptLogin()
    {
        try {
            $username = $this->request->getVar('username');
            $password = $this->request->getVar('password');

            // Debug info (remove in production)
            if (ENVIRONMENT === 'development') {
                log_message('debug', 'Login attempt - Username: ' . $username);
                error_log('Login attempt - Username: ' . $username);
            }

            // Validate input
            if (empty($username) || empty($password)) {
                session()->setFlashdata('message', 'Username dan password harus diisi.');
                return redirect()->to('/login')->withInput();
            }

            $userModel = new \App\Models\UserModel();
            $user = $userModel->where('username', $username)->first();

            if (!$user) {
                if (ENVIRONMENT === 'development') {
                    log_message('debug', 'User not found: ' . $username);
                    error_log('User not found: ' . $username);
                }
                session()->setFlashdata('message', 'Username "' . $username . '" tidak ditemukan.');
                return redirect()->to('/login')->withInput();
            }

            if (!password_verify($password, $user['password_hash'])) {
                if (ENVIRONMENT === 'development') {
                    log_message('debug', 'Password verification failed for user: ' . $username);
                    error_log('Password verification failed for user: ' . $username);
                }
                session()->setFlashdata('message', 'Password salah untuk user "' . $username . '".');
                return redirect()->to('/login')->withInput();
            }

            // Login successful
            $sessionData = [
                'user_id'    => $user['id'],
                'username'   => $user['username'],
                'isLoggedIn' => true
            ];
            
            session()->set($sessionData);
            
            if (ENVIRONMENT === 'development') {
                log_message('debug', 'Login successful for user: ' . $username);
                error_log('Login successful for user: ' . $username);
            }
            
            session()->setFlashdata('message', 'Login berhasil! Selamat datang ' . $user['username']);
            return redirect()->to('/admin');
            
        } catch (\Exception $e) {
            if (ENVIRONMENT === 'development') {
                log_message('error', 'Login error: ' . $e->getMessage());
                error_log('Login error: ' . $e->getMessage());
            }
            session()->setFlashdata('message', 'Terjadi kesalahan saat login. Silakan coba lagi.');
            return redirect()->to('/login');
        }
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/login');
    }
}
