<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class UserSeeder extends Seeder
{
    public function run()
    {
        $data = [
            'username' => 'rahma',
            'password_hash' => password_hash('rahma', PASSWORD_DEFAULT),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        // Check if user exists
        $userModel = new \App\Models\UserModel();
        // If user rahma does not exist, insert
        if (!$userModel->where('username', 'rahma')->first()) {
            $this->db->table('users')->insert($data);
        } else {
            // Optional: Update password if user exists to ensure it is rahma123
            $this->db->table('users')->where('username', 'rahma')->update($data);
        }
    }
}
