<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $title ?? 'Portofolio Digital'; ?></title>
    <link rel="icon" href="https://fav.farm/🌸" />
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

    <!-- Google Fonts: Plus Jakarta Sans -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">

    <!-- Custom CSS -->
    <link href="<?= base_url('css/style.css?v=' . time()); ?>" rel="stylesheet">
</head>

<body>

    <!-- Dynamic Background Orbs -->
    <div class="bg-orb bg-orb-1"></div>
    <div class="bg-orb bg-orb-2"></div>
    <div class="bg-orb bg-orb-3"></div>

    <?= $this->include('layout/navbar'); ?>

    <div class="container py-5 mt-5 position-relative">
        <?php if (session()->getFlashdata('message')): ?>
            <div class="alert alert-success reveal" role="alert">
                <?= session()->getFlashdata('message'); ?>
            </div>
        <?php endif; ?>
        <?= $this->renderSection('content'); ?>
    </div>

    <!-- Scroll to Top Button -->
    <button class="scroll-to-top" id="scrollToTop" onclick="scrollToTop()">
        <i class="bi bi-arrow-up"></i>
    </button>

    <div class="mt-auto pb-4 px-3 reveal">
        <footer class="footer-floating">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-4 col-md-6 mb-4 mb-md-0">
                        <h5 class="fw-bold mb-3 text-gradient-pink"><i
                                class="bi bi-person-badge-fill me-2"></i>Portofolio Digital</h5>
                        <p class="text-secondary small">
                            Platform personal untuk menampilkan biodata, riwayat pendidikan, dan catatan aktivitas
                            harian secara profesional dan modern dengan desain yang elegan.
                        </p>
                    </div>
                    <div class="col-lg-2 col-md-6 mb-4 mb-md-0">
                        <h6 class="text-uppercase fw-bold mb-3 small text-muted">Menu</h6>
                        <ul class="list-unstyled mb-0">
                            <li class="mb-2"><a href="<?= base_url('/'); ?>"
                                    class="text-secondary text-decoration-none small hover-link">Biodata</a></li>
                            <li class="mb-2"><a href="<?= base_url('/pendidikan'); ?>"
                                    class="text-secondary text-decoration-none small hover-link">Pendidikan</a></li>
                            <li class="mb-2"><a href="<?= base_url('/aktivitas'); ?>"
                                    class="text-secondary text-decoration-none small hover-link">Aktivitas</a></li>
                        </ul>
                    </div>
                    <div class="col-lg-3 col-md-6 mb-4 mb-md-0">
                        <h6 class="text-uppercase fw-bold mb-3 small text-muted">Connect</h6>
                        <?php
                        // Fetch social links directly for layout
                        $dbBiodata = (new \App\Models\BiodataModel())->first();
                        ?>
                        <div class="d-flex gap-3">
                            <?php if (!empty($dbBiodata['link_github'])): ?>
                                <a href="<?= $dbBiodata['link_github']; ?>" target="_blank" class="social-icon-box"
                                    style="background: var(--primary-color); color: white;"><i class="bi bi-github"></i></a>
                            <?php endif; ?>
                            <?php if (!empty($dbBiodata['link_linkedin'])): ?>
                                <a href="<?= $dbBiodata['link_linkedin']; ?>" target="_blank" class="social-icon-box"
                                    style="background: #0077b5; color: white;"><i class="bi bi-linkedin"></i></a>
                            <?php endif; ?>
                            <?php if (!empty($dbBiodata['link_instagram'])): ?>
                                <a href="<?= $dbBiodata['link_instagram']; ?>" target="_blank" class="social-icon-box"
                                    style="background: #e4405f; color: white;"><i class="bi bi-instagram"></i></a>
                            <?php endif; ?>
                            <?php if (!empty($dbBiodata['link_twitter'])): ?>
                                <a href="<?= $dbBiodata['link_twitter']; ?>" target="_blank" class="social-icon-box"
                                    style="background: black; color: white;"><i class="bi bi-twitter-x"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h6 class="text-uppercase fw-bold mb-3 small text-muted">Newsletter</h6>
                        <p class="text-secondary small mb-3">Dapatkan update terbaru.</p>
                        <div class="input-group mb-3">
                            <input type="text" class="form-control form-control-sm border-0 bg-light"
                                placeholder="Email address" aria-label="Email">
                            <button class="btn btn-primary btn-sm rounded-end" type="button"><i
                                    class="bi bi-send"></i></button>
                        </div>
                    </div>
                </div>

                <hr class="my-4 opacity-10">

                <div class="text-center text-secondary small">
                    &copy; <?= date('Y'); ?> Portofolio Digital. Built with <span class="text-primary">💜</span>
                    CodeIgniter 4 & Bootstrap 5.
                </div>
            </div>
        </footer>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function confirmDelete() {
            return confirm("Apakah Anda yakin ingin menghapus item ini?");
        }

        function scrollToTop() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }

        document.addEventListener('DOMContentLoaded', function () {
            // Navbar Scroll Effect
            const navbar = document.querySelector('.navbar');
            const scrollToTopBtn = document.getElementById('scrollToTop');

            if (navbar) {
                // Initial check
                if (window.scrollY > 50) {
                    navbar.classList.add('navbar-scrolled');
                    navbar.classList.remove('navbar-transparent');
                } else {
                    navbar.classList.add('navbar-transparent');
                    navbar.classList.remove('navbar-scrolled');
                }

                window.addEventListener('scroll', function () {
                    if (window.scrollY > 50) {
                        navbar.classList.add('navbar-scrolled');
                        navbar.classList.remove('navbar-transparent');
                    } else {
                        navbar.classList.add('navbar-transparent');
                        navbar.classList.remove('navbar-scrolled');
                    }

                    // Scroll to top button
                    if (scrollToTopBtn) {
                        if (window.scrollY > 300) {
                            scrollToTopBtn.classList.add('show');
                        } else {
                            scrollToTopBtn.classList.remove('show');
                        }
                    }
                });
            }

            // Scroll Reveal Animation
            const observerOptions = {
                threshold: 0.1,
                rootMargin: "0px 0px -50px 0px"
            };

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('active');
                        observer.unobserve(entry.target); // Only animate once
                    }
                });
            }, observerOptions);

            document.querySelectorAll('.reveal').forEach((el) => {
                observer.observe(el);
            });

            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();
                    const target = document.querySelector(this.getAttribute('href'));
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });

            // Add loading animation to buttons
            document.querySelectorAll('.btn').forEach(btn => {
                btn.addEventListener('click', function () {
                    if (this.type === 'submit') {
                        const originalText = this.innerHTML;
                        this.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Memproses...';
                        this.disabled = true;

                        setTimeout(() => {
                            this.innerHTML = originalText;
                            this.disabled = false;
                        }, 2000);
                    }
                });
            });

            // Initialize tooltips
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });

            // Add hover effects to cards
            document.querySelectorAll('.hover-card').forEach(card => {
                card.addEventListener('mouseenter', function () {
                    this.style.transform = 'translateY(-5px) scale(1.02)';
                });

                card.addEventListener('mouseleave', function () {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            });

            // Handle image loading errors
            document.querySelectorAll('img').forEach(img => {
                img.addEventListener('error', function () {
                    console.log('Image failed to load:', this.src);
                    // If it's not already a UI Avatar, try to load UI Avatar
                    if (!this.src.includes('ui-avatars.com')) {
                        const name = this.alt || 'User';
                        const size = this.width || 300;
                        this.src = `https://ui-avatars.com/api/?name=${encodeURIComponent(name)}&size=${size}&background=8b5cf6&color=ffffff&font-size=0.4&rounded=true`;
                    }
                });

                img.addEventListener('load', function () {
                    this.style.opacity = '1';
                });
            });
        });

        // Fallback avatar functions
        function showFallbackAvatar(img, initials) {
            const parent = img.parentElement;
            const fallbackDiv = document.createElement('div');
            fallbackDiv.className = img.className + ' avatar-fallback large';
            fallbackDiv.style.cssText = 'background: linear-gradient(135deg, #8b5cf6, #a855f7); font-size: 6rem;';
            fallbackDiv.textContent = initials || 'U';
            parent.replaceChild(fallbackDiv, img);
        }

        function showFallbackAvatarSmall(img, initials) {
            const parent = img.parentElement;
            const fallbackDiv = document.createElement('div');
            fallbackDiv.className = img.className + ' avatar-fallback small';
            fallbackDiv.style.cssText = img.style.cssText + ' background: linear-gradient(135deg, #8b5cf6, #a855f7); font-size: 2rem;';
            fallbackDiv.textContent = initials || 'U';
            parent.replaceChild(fallbackDiv, img);
        }

        // Auto-generate initials from name
        function generateInitials(name) {
            if (!name) return 'U';
            const words = name.trim().split(' ');
            let initials = '';
            for (let i = 0; i < Math.min(2, words.length); i++) {
                if (words[i]) {
                    initials += words[i].charAt(0).toUpperCase();
                }
            }
            return initials || 'U';
        }

        // Add some interactive feedback
        window.addEventListener('load', function () {
            // Show welcome message
            setTimeout(() => {
                if (window.location.pathname === '/' || window.location.pathname === '/biodata') {
                    console.log('🎉 Selamat datang di Portofolio Digital dengan tema ungu yang elegan!');
                }
            }, 1000);
        });
    </script>
</body>

</html>