<?php

// Debug login issue
session_start();

echo "<h2>Debug Login Issue</h2>";

// Check if this is a POST request (login attempt)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<h3>POST Data Received:</h3>";
    echo "<pre>";
    print_r($_POST);
    echo "</pre>";
    
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    echo "<h3>Processing Login:</h3>";
    echo "Username: " . htmlspecialchars($username) . "<br>";
    echo "Password: " . htmlspecialchars($password) . "<br>";
    
    // Database connection
    $host = 'localhost';
    $dbname = 'db_activity_biodata';
    $username_db = 'root';
    $password_db = 'Elaina870.';
    
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username_db, $password_db);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Find user
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if (!$user) {
            echo "<div style='color: red;'>❌ User not found!</div>";
        } else {
            echo "<div style='color: green;'>✅ User found:</div>";
            echo "ID: " . $user['id'] . "<br>";
            echo "Username: " . $user['username'] . "<br>";
            echo "Password Hash: " . $user['password_hash'] . "<br>";
            
            // Verify password
            $isValid = password_verify($password, $user['password_hash']);
            if ($isValid) {
                echo "<div style='color: green;'>✅ Password is correct!</div>";
                
                // Set session
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['isLoggedIn'] = true;
                
                echo "<div style='color: green;'>✅ Session set successfully!</div>";
                echo "<h3>Session Data:</h3>";
                echo "<pre>";
                print_r($_SESSION);
                echo "</pre>";
                
                echo "<p><a href='/admin' style='background: #8b5cf6; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Go to Admin Panel</a></p>";
                
            } else {
                echo "<div style='color: red;'>❌ Password is incorrect!</div>";
                echo "Expected: " . htmlspecialchars($password) . "<br>";
                echo "Hash: " . $user['password_hash'] . "<br>";
                
                // Test with new hash
                $newHash = password_hash($password, PASSWORD_DEFAULT);
                echo "New hash test: " . (password_verify($password, $newHash) ? 'SUCCESS' : 'FAILED') . "<br>";
            }
        }
        
    } catch (Exception $e) {
        echo "<div style='color: red;'>Database Error: " . $e->getMessage() . "</div>";
    }
    
} else {
    // Show login form
    echo "<h3>Test Login Form:</h3>";
    ?>
    <form method="POST" style="max-width: 400px; margin: 20px 0;">
        <div style="margin-bottom: 15px;">
            <label>Username:</label><br>
            <input type="text" name="username" value="lyraa" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
        </div>
        <div style="margin-bottom: 15px;">
            <label>Password:</label><br>
            <input type="password" name="password" value="lyraa123" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
        </div>
        <button type="submit" style="background: #8b5cf6; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer;">
            Test Login
        </button>
    </form>
    <?php
}

echo "<h3>Current Session:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h3>Server Info:</h3>";
echo "PHP Version: " . PHP_VERSION . "<br>";
echo "Session ID: " . session_id() . "<br>";
echo "Session Status: " . session_status() . "<br>";

?>