<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ActivitySeeder extends Seeder
{
    public function run()
    {
        $activities = [
            [
                'title'         => 'E-Commerce Platform Development',
                'slug'          => 'e-commerce-platform-development',
                'description'   => 'Membangun platform e-commerce fullstack untuk UMKM dengan fitur manajemen produk, keranjang belanja, integrasi payment gateway (Midtrans), dan dashboard analytics. Menggunakan CodeIgniter 4, MySQL, dan Bootstrap 5.',
                'category'      => 'Project',
                'tags'          => json_encode(['PHP', 'CodeIgniter', 'MySQL', 'Bootstrap', 'Midtrans']),
                'activity_date' => '2024-10-15',
                'status'        => 'published',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Company Profile Website Redesign',
                'slug'          => 'company-profile-website-redesign',
                'description'   => 'Redesain total website company profile untuk startup teknologi lokal. Fokus pada modern UI/UX, animasi interaktif dengan GSAP, dan optimasi SEO. Meningkatkan page speed score dari 45 menjadi 95.',
                'category'      => 'Freelance',
                'tags'          => json_encode(['HTML', 'CSS', 'JavaScript', 'GSAP', 'SEO']),
                'activity_date' => '2024-08-20',
                'status'        => 'published',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Learning Management System',
                'slug'          => 'learning-management-system',
                'description'   => 'Proyek capstone untuk mata kuliah Rekayasa Perangkat Lunak. Membangun LMS dengan fitur manajemen kursus, video streaming, quiz interaktif, dan sertifikat otomatis. Tim 4 orang dengan metode Agile Scrum.',
                'category'      => 'Campus',
                'tags'          => json_encode(['Laravel', 'Vue.js', 'MySQL', 'Agile']),
                'activity_date' => '2024-06-10',
                'status'        => 'published',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Inventory Management API',
                'slug'          => 'inventory-management-api',
                'description'   => 'Backend REST API untuk sistem manajemen inventaris warehouse. Fitur: autentikasi JWT, barcode scanning, real-time stock tracking, dan reporting. Dokumentasi API dengan Swagger.',
                'category'      => 'Project',
                'tags'          => json_encode(['PHP', 'REST API', 'JWT', 'MySQL', 'Swagger']),
                'activity_date' => '2024-04-05',
                'status'        => 'published',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Portfolio Website dengan Three.js',
                'slug'          => 'portfolio-website-threejs',
                'description'   => 'Personal portfolio website dengan 3D interactive hero section menggunakan Three.js. Implementasi glass morphism, smooth scroll animations, dan responsive design.',
                'category'      => 'Project',
                'tags'          => json_encode(['Three.js', 'JavaScript', 'CSS', 'WebGL']),
                'activity_date' => '2024-02-28',
                'status'        => 'published',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Hackathon Nasional 2024',
                'slug'          => 'hackathon-nasional-2024',
                'description'   => 'Finalis Hackathon Nasional dengan project smart parking system menggunakan IoT dan machine learning untuk prediksi ketersediaan slot. Presentasi pitch ke panel juri dari industri.',
                'category'      => 'Campus',
                'tags'          => json_encode(['IoT', 'Machine Learning', 'Python', 'Presentation']),
                'activity_date' => '2024-01-15',
                'status'        => 'published',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Mobile App Landing Page',
                'slug'          => 'mobile-app-landing-page',
                'description'   => 'Landing page untuk startup fintech dengan animasi premium dan conversion-optimized design. Implementasi A/B testing untuk meningkatkan signup rate.',
                'category'      => 'Freelance',
                'tags'          => json_encode(['HTML', 'CSS', 'JavaScript', 'UI/UX']),
                'activity_date' => '2023-11-20',
                'status'        => 'published',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Blog CMS Development',
                'slug'          => 'blog-cms-development',
                'description'   => 'Custom CMS untuk blog multi-author dengan fitur rich text editor, kategori, tagging, dan SEO optimization. Dashboard analytics untuk tracking page views.',
                'category'      => 'Project',
                'tags'          => json_encode(['PHP', 'MySQL', 'TinyMCE', 'Analytics']),
                'activity_date' => '2023-09-08',
                'status'        => 'draft',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
        ];

        $this->db->table('activities')->insertBatch($activities);
    }
}
