<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class BiodataSeeder extends Seeder
{
    public function run()
    {
        $skills = json_encode([
            'PHP', 'CodeIgniter', 'Laravel', 'JavaScript', 
            'Vue.js', 'MySQL', 'Bootstrap', 'Tailwind CSS',
            'Git', 'REST API', 'Three.js'
        ]);

        $data = [
            'full_name'     => 'Ahmad Fauzan',
            'headline'      => 'Full-Stack Web Developer | Creative Technologist',
            'location'      => 'Jakarta, Indonesia',
            'email_public'  => 'hello@ahmadfauzan.dev',
            'phone_public'  => '+62 812 3456 7890',
            'about'         => 'Seorang developer berpengalaman dengan passion dalam membangun aplikasi web modern dan interaktif. Memiliki 5+ tahun pengalaman dalam pengembangan full-stack dengan fokus pada user experience yang premium dan performa tinggi. Selalu antusias mempelajari teknologi baru dan menerapkan best practices dalam setiap proyek.',
            'skills'        => $skills,
            'photo'         => null,
            'linkedin_url'  => 'https://linkedin.com/in/ahmadfauzan',
            'github_url'    => 'https://github.com/ahmadfauzan',
            'portfolio_url' => 'https://ahmadfauzan.dev',
            'created_at'    => date('Y-m-d H:i:s'),
            'updated_at'    => date('Y-m-d H:i:s'),
        ];

        $this->db->table('biodata')->insert($data);
    }
}
