<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class EducationSeeder extends Seeder
{
    public function run()
    {
        $educations = [
            [
                'institution' => 'Universitas Indonesia',
                'major'       => 'Teknik Informatika',
                'degree'      => 'S1',
                'start_year'  => 2021,
                'end_year'    => null,
                'gpa'         => 3.75,
                'description' => 'Fokus pada pengembangan software engineering dan web technologies. Aktif di organisasi mahasiswa sebagai koordinator divisi IT. Mengikuti berbagai kompetisi programming tingkat nasional.',
                'status'      => 'ongoing',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'SMKN 1 Jakarta',
                'major'       => 'Rekayasa Perangkat Lunak',
                'degree'      => 'SMK',
                'start_year'  => 2018,
                'end_year'    => 2021,
                'gpa'         => 3.85,
                'description' => 'Jurusan unggulan dengan kurikulum berbasis industri. Magang di software house lokal selama 6 bulan. Proyek akhir: Sistem Informasi Perpustakaan Digital.',
                'status'      => 'completed',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'Dicoding Indonesia',
                'major'       => 'Back-End Developer Expert',
                'degree'      => 'Sertifikasi',
                'start_year'  => 2023,
                'end_year'    => 2023,
                'gpa'         => null,
                'description' => 'Program beasiswa dari Kampus Merdeka. Mempelajari arsitektur backend, clean code, continuous integration, dan deployment. Lulus dengan predikat sangat baik.',
                'status'      => 'completed',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'Google Developer',
                'major'       => 'Associate Cloud Engineer',
                'degree'      => 'Sertifikasi',
                'start_year'  => 2024,
                'end_year'    => 2024,
                'gpa'         => null,
                'description' => 'Sertifikasi Google Cloud Platform untuk cloud computing, deployment, dan infrastructure management. Valid hingga 2027.',
                'status'      => 'completed',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
        ];

        $this->db->table('educations')->insertBatch($educations);
    }
}
