<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="admin-form-card">
    <form action="<?= $education ? base_url('admin/pendidikan/update/' . $education['id']) : base_url('admin/pendidikan/store') ?>" method="post">
        <?= csrf_field() ?>
        
        <div class="form-group">
            <label for="institution" class="form-label">Institusi *</label>
            <input type="text" id="institution" name="institution" class="form-control" value="<?= old('institution', $education['institution'] ?? '') ?>" placeholder="Universitas Indonesia" required>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="major" class="form-label">Jurusan/Program *</label>
                <input type="text" id="major" name="major" class="form-control" value="<?= old('major', $education['major'] ?? '') ?>" placeholder="Teknik Informatika" required>
            </div>
            
            <div class="form-group">
                <label for="degree" class="form-label">Jenjang *</label>
                <input type="text" id="degree" name="degree" class="form-control" value="<?= old('degree', $education['degree'] ?? '') ?>" placeholder="S1, D3, SMK, Sertifikasi" required>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="start_year" class="form-label">Tahun Mulai *</label>
                <input type="number" id="start_year" name="start_year" class="form-control" value="<?= old('start_year', $education['start_year'] ?? '') ?>" min="1990" max="2030" placeholder="2021" required>
            </div>
            
            <div class="form-group">
                <label for="end_year" class="form-label">Tahun Selesai</label>
                <input type="number" id="end_year" name="end_year" class="form-control" value="<?= old('end_year', $education['end_year'] ?? '') ?>" min="1990" max="2030" placeholder="Kosongkan jika masih berjalan">
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="gpa" class="form-label">IPK/Nilai</label>
                <input type="number" id="gpa" name="gpa" class="form-control" value="<?= old('gpa', $education['gpa'] ?? '') ?>" step="0.01" min="0" max="4" placeholder="3.75">
            </div>
            
            <div class="form-group">
                <label for="status" class="form-label">Status *</label>
                <select id="status" name="status" class="form-control" required>
                    <option value="ongoing" <?= old('status', $education['status'] ?? 'ongoing') === 'ongoing' ? 'selected' : '' ?>>Ongoing (Masih Berjalan)</option>
                    <option value="completed" <?= old('status', $education['status'] ?? '') === 'completed' ? 'selected' : '' ?>>Completed (Selesai)</option>
                </select>
            </div>
        </div>
        
        <div class="form-group">
            <label for="description" class="form-label">Deskripsi</label>
            <textarea id="description" name="description" class="form-control" rows="4" placeholder="Deskripsi singkat tentang pendidikan ini..."><?= old('description', $education['description'] ?? '') ?></textarea>
        </div>
        
        <div style="display: flex; gap: var(--space-4); margin-top: var(--space-6);">
            <button type="submit" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                    <polyline points="17 21 17 13 7 13 7 21"></polyline>
                    <polyline points="7 3 7 8 15 8"></polyline>
                </svg>
                <?= $education ? 'Update' : 'Simpan' ?>
            </button>
            <a href="<?= base_url('admin/pendidikan') ?>" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>
