<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>
<section class="section">
    <div class="container">
        <div class="section-header">
            <h1 class="section-title">Updates</h1>
            <p class="section-subtitle">Catatan dan pembaruan terbaru</p>
        </div>
        
        <?php if ($enabled && !empty($notionUrl)): ?>
        <!-- Notion Embed -->
        <div style="background: var(--color-bg-primary); border-radius: var(--radius-xl); overflow: hidden; box-shadow: var(--shadow-lg);">
            <iframe 
                src="<?= esc($notionUrl) ?>" 
                class="notion-embed"
                title="Notion Updates"
                loading="lazy"
            ></iframe>
        </div>
        <?php else: ?>
        <!-- Notion Disabled -->
        <div class="notion-disabled">
            <div style="font-size: 4rem; margin-bottom: var(--space-4);">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" style="color: var(--color-text-muted);">
                    <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
                    <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
                </svg>
            </div>
            <h3 style="color: var(--color-text-secondary); margin-bottom: var(--space-2);">Notion Integration Disabled</h3>
            <p style="color: var(--color-text-muted); max-width: 400px; margin: 0 auto;">
                Integrasi Notion belum dikonfigurasi. Hubungi administrator untuk mengaktifkan fitur ini.
            </p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
