<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\EducationModel;

class Education extends BaseController
{
    protected $educationModel;

    public function __construct()
    {
        $this->educationModel = new EducationModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'id';
        $order = $this->request->getGet('order') ?? 'DESC';

        $model = $this->educationModel;

        if ($search) {
            $model->groupStart()
                ->like('nama_sekolah', $search)
                ->orLike('jurusan', $search)
                ->orLike('jenjang', $search)
                ->groupEnd();
        }

        $data = [
            'title' => 'Riwayat Pendidikan',
            'education' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'sort' => $sort,
            'order' => $order
        ];
        return view('admin/education/index', $data);
    }

    public function create()
    {
        $data = ['title' => 'Tambah Pendidikan'];
        return view('admin/education/create', $data);
    }

    public function store()
    {
        if (!$this->validate([
            'nama_sekolah' => 'required',
            'tahun_masuk' => 'required|numeric',
        ])) {
            return redirect()->to('/admin/education/create')->withInput()->with('errors', $this->validator->getErrors());
        }

        $this->educationModel->save([
            'jenjang' => $this->request->getPost('jenjang'),
            'nama_sekolah' => $this->request->getPost('nama_sekolah'),
            'jurusan' => $this->request->getPost('jurusan'),
            'tahun_masuk' => $this->request->getPost('tahun_masuk'),
            'tahun_lulus' => $this->request->getPost('tahun_lulus'),
            'nilai_akhir' => $this->request->getPost('nilai_akhir'),
            'prestasi' => $this->request->getPost('prestasi'),
            'alamat_sekolah' => $this->request->getPost('alamat_sekolah'),
        ]);

        return redirect()->to('/admin/education')->with('message', 'Pendidikan berhasil disimpan');
    }

    public function edit($id)
    {
        $data = [
            'title' => 'Edit Pendidikan',
            'education' => $this->educationModel->find($id)
        ];
        return view('admin/education/edit', $data);
    }

    public function update($id)
    {
        $this->educationModel->update($id, [
            'jenjang' => $this->request->getPost('jenjang'),
            'nama_sekolah' => $this->request->getPost('nama_sekolah'),
            'jurusan' => $this->request->getPost('jurusan'),
            'tahun_masuk' => $this->request->getPost('tahun_masuk'),
            'tahun_lulus' => $this->request->getPost('tahun_lulus'),
            'nilai_akhir' => $this->request->getPost('nilai_akhir'),
            'prestasi' => $this->request->getPost('prestasi'),
            'alamat_sekolah' => $this->request->getPost('alamat_sekolah'),
        ]);

        return redirect()->to('/admin/education')->with('message', 'Pendidikan berhasil diperbarui');
    }

    public function delete($id)
    {
        $this->educationModel->delete($id);
        return redirect()->to('/admin/education')->with('message', 'Pendidikan berhasil dihapus');
    }
}
