<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\EducationModel;
use App\Models\ActivityModel;

class Home extends BaseController
{
    public function index()
    {
        $biodataModel = new BiodataModel();
        // Get primary biodata (first one for now)
        $data = [
            'title' => 'Home - My Portfolio',
            'biodata' => $biodataModel->first()
        ];
        return view('home', $data);
    }

    public function biodata()
    {
        $biodataModel = new BiodataModel();
        $search = $this->request->getGet('search');
        
        if ($search) {
            $biodataModel->groupStart()
                ->like('nama', $search)
                ->orLike('keahlian', $search)
                ->groupEnd();
        }

        $data = [
            'title' => 'Biodata - My Portfolio',
            'biodata_list' => $biodataModel->paginate(10), // Using paginate for search results list logic
            'pager' => $biodataModel->pager,
            'search' => $search
        ];
        return view('biodata', $data);
    }

    public function education()
    {
        $educationModel = new EducationModel();
        
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'tahun_masuk';
        $order = $this->request->getGet('order') ?? 'DESC';

        if ($search) {
            $educationModel->groupStart()
                ->like('nama_sekolah', $search)
                ->orLike('jurusan', $search)
                ->groupEnd();
        }

        $data = [
            'title' => 'Education - My Portfolio',
            'education' => $educationModel->orderBy($sort, $order)->paginate(10),
            'pager' => $educationModel->pager,
            'search' => $search,
            'sort' => $sort,
            'order' => $order
        ];
        return view('education', $data);
    }

    public function activities()
    {
        $activityModel = new ActivityModel();

        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'tanggal';
        $order = $this->request->getGet('order') ?? 'DESC';

        if ($search) {
            $activityModel->groupStart()
                ->like('nama_aktivitas', $search)
                ->orLike('kategori', $search)
                ->groupEnd();
        }

        $data = [
            'title' => 'Activities - My Portfolio',
            'activities' => $activityModel->orderBy($sort, $order)->paginate(9), 
            'pager' => $activityModel->pager,
            'search' => $search,
            'sort' => $sort,
            'order' => $order
        ];
        return view('activities', $data);
    }
}