<?php

namespace App\Models;

use CodeIgniter\Model;

class AktivitasHarianModel extends Model
{
    protected $table = 'aktivitas_harian';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $protectFields = true;
    protected $allowedFields = [
        'tanggal', 'jam', 'nama_aktivitas', 'deskripsi', 
        'foto', 'video', 'kategori'
    ];

    protected $useTimestamps = true;
    protected $dateFormat = 'datetime';
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';

    protected $validationRules = [
        'tanggal' => 'required|valid_date',
        'jam' => 'required',
        'nama_aktivitas' => 'required|min_length[3]|max_length[200]',
        'deskripsi' => 'permit_empty',
        'foto' => 'permit_empty|max_length[255]',
        'video' => 'permit_empty|max_length[255]',
        'kategori' => 'permit_empty|max_length[100]'
    ];

    protected $validationMessages = [
        'tanggal' => [
            'required' => 'Tanggal harus diisi',
            'valid_date' => 'Format tanggal tidak valid'
        ],
        'jam' => [
            'required' => 'Jam harus diisi'
        ],
        'nama_aktivitas' => [
            'required' => 'Nama aktivitas harus diisi',
            'min_length' => 'Nama aktivitas minimal 3 karakter',
            'max_length' => 'Nama aktivitas maksimal 200 karakter'
        ]
    ];

    public function search($keyword = '', $kategori = '', $tanggal_dari = '', $tanggal_sampai = '', $limit = 10, $offset = 0, $orderBy = 'tanggal', $orderDir = 'DESC')
    {
        $builder = $this->builder();
        
        if (!empty($keyword)) {
            $builder->groupStart()
                    ->like('nama_aktivitas', $keyword)
                    ->orLike('deskripsi', $keyword)
                    ->orLike('kategori', $keyword)
                    ->groupEnd();
        }
        
        if (!empty($kategori)) {
            $builder->where('kategori', $kategori);
        }
        
        if (!empty($tanggal_dari)) {
            $builder->where('tanggal >=', $tanggal_dari);
        }
        
        if (!empty($tanggal_sampai)) {
            $builder->where('tanggal <=', $tanggal_sampai);
        }
        
        return $builder->orderBy($orderBy, $orderDir)
                      ->limit($limit, $offset)
                      ->get()
                      ->getResultArray();
    }

    public function countSearch($keyword = '', $kategori = '', $tanggal_dari = '', $tanggal_sampai = '')
    {
        $builder = $this->builder();
        
        if (!empty($keyword)) {
            $builder->groupStart()
                    ->like('nama_aktivitas', $keyword)
                    ->orLike('deskripsi', $keyword)
                    ->orLike('kategori', $keyword)
                    ->groupEnd();
        }
        
        if (!empty($kategori)) {
            $builder->where('kategori', $kategori);
        }
        
        if (!empty($tanggal_dari)) {
            $builder->where('tanggal >=', $tanggal_dari);
        }
        
        if (!empty($tanggal_sampai)) {
            $builder->where('tanggal <=', $tanggal_sampai);
        }
        
        return $builder->countAllResults();
    }

    public function getKategoriList()
    {
        return $this->builder()
                   ->select('kategori')
                   ->where('kategori IS NOT NULL')
                   ->where('kategori !=', '')
                   ->groupBy('kategori')
                   ->orderBy('kategori', 'ASC')
                   ->get()
                   ->getResultArray();
    }
}