<?php

namespace App\Models;

use CodeIgniter\Model;

class EducationModel extends Model
{
    protected $table            = 'riwayat_pendidikan';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $allowedFields    = [
        'jenjang', 'nama_sekolah', 'jurusan', 'tahun_masuk', 
        'tahun_lulus', 'nilai_akhir', 'prestasi', 'alamat_sekolah'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules      = [
        'jenjang' => 'required',
        'nama_sekolah' => 'required|max_length[200]',
        'tahun_masuk' => 'required|exact_length[4]|numeric',
    ];
}
