<?= $this->extend('layout/public') ?>

<?= $this->section('content') ?>

<div class="mb-10 text-center">
    <h1 class="text-3xl font-bold text-gray-900 mb-4">Biodata & Profil</h1>
    <p class="text-gray-500 max-w-2xl mx-auto">Mengenal saya lebih baik. Berikut adalah tampilan lengkap detail pribadi dan keahlian profesional saya.</p>
</div>

<!-- Search -->
<div class="max-w-md mx-auto mb-12">
    <form action="" method="get" class="relative">
        <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari keahlian atau nama..." class="w-full pl-12 pr-4 py-3 rounded-full border border-gray-200 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent shadow-sm">
        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-400">
            <i class="fa-solid fa-search"></i>
        </div>
        <button type="submit" class="absolute right-2 top-2 px-4 py-1 bg-purple-600 text-white rounded-full text-sm font-medium hover:bg-purple-700">Cari</button>
    </form>
</div>

<div class="grid gap-8">
    <?php foreach ($biodata_list as $item) : ?>
    <div class="bg-white rounded-2xl shadow-sm hover:shadow-lg transition-all duration-300 overflow-hidden border border-purple-50">
        <div class="md:flex">
            <div class="md:flex-shrink-0 bg-purple-50 md:w-64 flex items-center justify-center p-8">
                <?php if(!empty($item['foto'])): ?>
                    <img src="/uploads/photos/<?= esc($item['foto']) ?>" alt="Profile" class="h-32 w-32 rounded-full object-cover border-4 border-white shadow-md">
                <?php else: ?>
                    <div class="h-32 w-32 rounded-full bg-white flex items-center justify-center text-purple-200 border-4 border-purple-100">
                        <i class="fa-solid fa-user text-5xl"></i>
                    </div>
                <?php endif; ?>
            </div>
            <div class="p-8 w-full">
                <div class="uppercase tracking-wide text-sm text-purple-600 font-semibold mb-1"><?= esc($item['keahlian'] ?? 'Developer') ?></div>
                <h2 class="block mt-1 text-2xl leading-tight font-bold text-gray-900 mb-4"><?= esc($item['nama']) ?></h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-y-4 gap-x-8 text-gray-600 mb-6">
                    <div class="flex items-center">
                        <i class="fa-solid fa-envelope w-6 text-purple-400"></i>
                        <span><?= esc($item['email']) ?></span>
                    </div>
                    <?php if(!empty($item['telepon'])): ?>
                    <div class="flex items-center">
                        <i class="fa-solid fa-phone w-6 text-purple-400"></i>
                        <span><?= esc($item['telepon']) ?></span>
                    </div>
                    <?php endif; ?>
                    <div class="flex items-center">
                        <i class="fa-solid fa-map-marker-alt w-6 text-purple-400"></i>
                        <span><?= esc($item['alamat']) ?></span>
                    </div>
                    <div class="flex items-center">
                        <i class="fa-solid fa-cake-candles w-6 text-purple-400"></i>
                        <span><?= esc($item['tempat_lahir']) ?>, <?= esc($item['tanggal_lahir']) ?></span>
                    </div>
                </div>
                <p class="text-gray-500 leading-relaxed border-t border-gray-100 pt-4">
                    <?= esc($item['deskripsi']) ?>
                </p>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    
    <?php if(empty($biodata_list)): ?>
        <div class="text-center py-12 text-gray-500 bg-white rounded-xl">
            <i class="fa-regular fa-folder-open text-4xl mb-4 text-gray-300"></i>
            <p>Tidak ada profil ditemukan.</p>
        </div>
    <?php endif; ?>
</div>

<div class="mt-8 flex justify-center">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>
