<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<!-- Hero Section -->
<section class="gradient-purple text-white py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center animate-slide-in">
            <div class="w-32 h-32 mx-auto mb-8 rounded-full bg-white/20 backdrop-blur-sm flex items-center justify-center">
                <?php if ($biodata && $biodata['foto']): ?>
                    <img src="<?= base_url('uploads/biodata/' . $biodata['foto']) ?>" alt="Profile" class="w-28 h-28 rounded-full object-cover">
                <?php else: ?>
                    <i class="fas fa-user text-6xl text-white/80"></i>
                <?php endif; ?>
            </div>
            
            <h1 class="text-5xl md:text-6xl font-bold mb-6">
                <?= $biodata['nama'] ?? 'Selamat Datang' ?>
            </h1>
            
            <p class="text-xl md:text-2xl mb-8 text-white/90 max-w-3xl mx-auto">
                <?= $biodata['deskripsi'] ?? 'Aplikasi Portofolio Digital dengan CodeIgniter 4' ?>
            </p>
            
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?= base_url('/biodata') ?>" class="bg-white text-purple-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-all duration-300 transform hover:scale-105">
                    <i class="fas fa-id-card mr-2"></i>Lihat Biodata
                </a>
                <a href="<?= base_url('/aktivitas') ?>" class="border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-purple-600 transition-all duration-300 transform hover:scale-105">
                    <i class="fas fa-calendar-alt mr-2"></i>Aktivitas Terbaru
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center card-hover bg-gradient-to-br from-purple-50 to-indigo-50 p-8 rounded-xl">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-graduation-cap text-2xl text-white"></i>
                </div>
                <h3 class="text-3xl font-bold text-gray-800 mb-2"><?= $education_count ?></h3>
                <p class="text-gray-600">Riwayat Pendidikan</p>
            </div>
            
            <div class="text-center card-hover bg-gradient-to-br from-purple-50 to-indigo-50 p-8 rounded-xl">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-calendar-check text-2xl text-white"></i>
                </div>
                <h3 class="text-3xl font-bold text-gray-800 mb-2"><?= $activities_count ?></h3>
                <p class="text-gray-600">Total Aktivitas</p>
            </div>
            
            <div class="text-center card-hover bg-gradient-to-br from-purple-50 to-indigo-50 p-8 rounded-xl">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-star text-2xl text-white"></i>
                </div>
                <h3 class="text-3xl font-bold text-gray-800 mb-2">100%</h3>
                <p class="text-gray-600">Kepuasan</p>
            </div>
        </div>
    </div>
</section>

<!-- Recent Activities -->
<section class="py-16 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-4xl font-bold text-gray-800 mb-4">Aktivitas Terbaru</h2>
            <p class="text-xl text-gray-600">Lihat aktivitas terbaru yang telah dilakukan</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php if (!empty($recent_activities)): ?>
                <?php foreach ($recent_activities as $aktivitas): ?>
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden card-hover">
                        <?php if ($aktivitas['foto']): ?>
                            <div class="h-48 bg-gradient-to-br from-purple-400 to-indigo-500 flex items-center justify-center">
                                <img src="<?= base_url('uploads/aktivitas/' . $aktivitas['foto']) ?>" alt="<?= $aktivitas['nama_aktivitas'] ?>" class="w-full h-full object-cover">
                            </div>
                        <?php else: ?>
                            <div class="h-48 gradient-purple flex items-center justify-center">
                                <i class="fas fa-calendar-alt text-4xl text-white/80"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="p-6">
                            <div class="flex items-center text-sm text-gray-500 mb-2">
                                <i class="fas fa-calendar mr-2"></i>
                                <?= date('d M Y', strtotime($aktivitas['tanggal'])) ?>
                                <i class="fas fa-clock ml-4 mr-2"></i>
                                <?= date('H:i', strtotime($aktivitas['jam'])) ?>
                            </div>
                            
                            <h3 class="text-xl font-semibold text-gray-800 mb-2"><?= $aktivitas['nama_aktivitas'] ?></h3>
                            
                            <?php if ($aktivitas['deskripsi']): ?>
                                <p class="text-gray-600 mb-4"><?= substr($aktivitas['deskripsi'], 0, 100) ?><?= strlen($aktivitas['deskripsi']) > 100 ? '...' : '' ?></p>
                            <?php endif; ?>
                            
                            <?php if ($aktivitas['kategori']): ?>
                                <span class="inline-block bg-purple-100 text-purple-800 text-xs px-3 py-1 rounded-full">
                                    <?= $aktivitas['kategori'] ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-span-full text-center py-12">
                    <i class="fas fa-calendar-times text-6xl text-gray-300 mb-4"></i>
                    <p class="text-xl text-gray-500">Belum ada aktivitas yang tercatat</p>
                </div>
            <?php endif; ?>
        </div>
        
        <?php if (!empty($recent_activities)): ?>
            <div class="text-center mt-12">
                <a href="<?= base_url('/aktivitas') ?>" class="btn-purple text-white px-8 py-3 rounded-lg font-semibold inline-flex items-center">
                    <i class="fas fa-eye mr-2"></i>Lihat Semua Aktivitas
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Features Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-4xl font-bold text-gray-800 mb-4">Fitur Aplikasi</h2>
            <p class="text-xl text-gray-600">Jelajahi berbagai fitur yang tersedia</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center card-hover p-8 rounded-xl border border-gray-200">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-search text-2xl text-white"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Pencarian</h3>
                <p class="text-gray-600">Cari data dengan mudah menggunakan fitur pencarian yang canggih</p>
            </div>
            
            <div class="text-center card-hover p-8 rounded-xl border border-gray-200">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-filter text-2xl text-white"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Filter</h3>
                <p class="text-gray-600">Filter data berdasarkan kategori, tanggal, dan kriteria lainnya</p>
            </div>
            
            <div class="text-center card-hover p-8 rounded-xl border border-gray-200">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-sort text-2xl text-white"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Sorting</h3>
                <p class="text-gray-600">Urutkan data sesuai kebutuhan dengan berbagai opsi sorting</p>
            </div>
            
            <div class="text-center card-hover p-8 rounded-xl border border-gray-200">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-list text-2xl text-white"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Pagination</h3>
                <p class="text-gray-600">Navigasi data yang mudah dengan sistem pagination</p>
            </div>
            
            <div class="text-center card-hover p-8 rounded-xl border border-gray-200">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-mobile-alt text-2xl text-white"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Responsive</h3>
                <p class="text-gray-600">Tampilan yang optimal di semua perangkat dan ukuran layar</p>
            </div>
            
            <div class="text-center card-hover p-8 rounded-xl border border-gray-200">
                <div class="w-16 h-16 gradient-purple rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-cog text-2xl text-white"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Admin Panel</h3>
                <p class="text-gray-600">Panel admin lengkap untuk mengelola semua data dengan mudah</p>
            </div>
        </div>
    </div>
</section>

<?= $this->endSection() ?>