<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-edit"></i> Edit Pendidikan</h1>
            <a href="<?= base_url('admin/pendidikan') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <?php if ($pendidikan): ?>
            <form method="POST" action="<?= base_url('admin/pendidikan/edit/' . $pendidikan['id']) ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Jenjang *</label>
                    <select name="jenjang" class="form-control" required>
                        <option value="">Pilih Jenjang</option>
                        <option value="SD" <?= $pendidikan['jenjang'] === 'SD' ? 'selected' : '' ?>>SD</option>
                        <option value="SMP" <?= $pendidikan['jenjang'] === 'SMP' ? 'selected' : '' ?>>SMP</option>
                        <option value="SMA" <?= $pendidikan['jenjang'] === 'SMA' ? 'selected' : '' ?>>SMA</option>
                        <option value="S1" <?= $pendidikan['jenjang'] === 'S1' ? 'selected' : '' ?>>S1</option>
                        <option value="S2" <?= $pendidikan['jenjang'] === 'S2' ? 'selected' : '' ?>>S2</option>
                        <option value="S3" <?= $pendidikan['jenjang'] === 'S3' ? 'selected' : '' ?>>S3</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Institusi *</label>
                    <input type="text" name="institusi" class="form-control" value="<?= esc($pendidikan['institusi']) ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Jurusan</label>
                    <input type="text" name="jurusan" class="form-control" value="<?= esc($pendidikan['jurusan']) ?>">
                </div>
                
                <div class="form-group">
                    <label>Tahun Mulai</label>
                    <input type="number" name="tahun_mulai" class="form-control" value="<?= esc($pendidikan['tahun_mulai']) ?>" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Tahun Selesai</label>
                    <input type="number" name="tahun_selesai" class="form-control" value="<?= esc($pendidikan['tahun_selesai']) ?>" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="5"><?= esc($pendidikan['deskripsi']) ?></textarea>
                </div>

                <div class="form-group">
                    <label>Foto / Logo Institusi</label>
                    <?php if (!empty($pendidikan['foto'])): ?>
                        <div style="margin-bottom:8px;">
                            <img src="<?= base_url(esc($pendidikan['foto'])) ?>" alt="Foto institusi" style="max-width: 180px; border-radius: 10px; border: 1px solid #e5e7eb;">
                        </div>
                    <?php endif; ?>
                    <input type="file" name="foto_file" class="form-control" accept="image/*">
                    <input type="hidden" name="foto" value="<?= esc($pendidikan['foto'] ?? '') ?>">
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-save"></i> Update
                </button>
            </form>
            <?php else: ?>
            <p>Data tidak ditemukan</p>
            <?php endif; ?>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
