<?php

namespace App\Controllers\Frontend;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;
use App\Models\BiodataModel;

class Home extends BaseController
{
    public function index()
    {
        $aktivitasModel = new AktivitasModel();
        $biodataModel = new BiodataModel();

        $data = [
            'title' => 'Home - Portfolio Mahasiswa',
            'biodata' => $biodataModel->getBiodata(),
            'recentAktivitas' => $aktivitasModel->orderBy('tanggal', 'DESC')->limit(3)->findAll(),
        ];

        return view('frontend/home', $data);
    }
}
