<?php

namespace App\Controllers\Frontend;

use App\Controllers\BaseController;
use App\Models\RiwayatPendidikanModel;

class Pendidikan extends BaseController
{
    protected $pendidikanModel;

    public function __construct()
    {
        $this->pendidikanModel = new RiwayatPendidikanModel();
    }

    public function index()
    {
        // Get query parameters
        $search = $this->request->getGet('search');
        $jenjang = $this->request->getGet('jenjang');
        $sort = $this->request->getGet('sort') ?? 'tahun_masuk';
        $order = $this->request->getGet('order') ?? 'ASC';
        $page = $this->request->getGet('page') ?? 1;
        $perPage = 10;

        // Build query
        $builder = $this->pendidikanModel;

        // Search filter (minimum 3 characters)
        if ($search && strlen($search) >= 3) {
            $builder = $builder->groupStart()
                ->like('nama_sekolah', $search)
                ->orLike('jurusan', $search)
                ->groupEnd();
        } elseif ($search && strlen($search) < 3) {
            $search = ''; // Reset search if less than 3 chars
        }

        // Jenjang filter
        if ($jenjang) {
            $builder = $builder->where('jenjang', $jenjang);
        }

        // Sorting
        $allowedSorts = ['jenjang', 'nama_sekolah', 'tahun_masuk', 'tahun_lulus'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'tahun_masuk';
        $order = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';

        // Get total count for pagination
        $total = $builder->countAllResults(false);

        // Get paginated data
        $pendidikan = $builder->orderBy($sort, $order)
                             ->paginate($perPage, 'default', $page);

        $data = [
            'title' => 'Riwayat Pendidikan',
            'pendidikan' => $pendidikan,
            'pager' => $this->pendidikanModel->pager,
            'total' => $total,
            'search' => $search,
            'jenjang' => $jenjang,
            'sort' => $sort,
            'order' => $order,
            'currentPage' => $page,
            'jenjangOptions' => ['SD', 'SMP', 'SMA', 'Kuliah'],
        ];

        return view('frontend/pendidikan', $data);
    }
}
